/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.data.xy.WindDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class WindChartDemo
extends ApplicationFrame {
    public WindChartDemo(String string) {
        super(string);
        WindDataset windDataset = DemoDatasetFactory.createWindDataset1();
        JFreeChart jFreeChart = this.createChart(windDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(WindDataset windDataset) {
        JFreeChart jFreeChart = ChartFactory.createWindPlot("Wind Chart Demo", "Date", "Direction / Force", windDataset, true, false, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        WindChartDemo windChartDemo = new WindChartDemo("Wind Chart Demo");
        windChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(windChartDemo);
        windChartDemo.setVisible(true);
    }
}

