/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class WaterTemperatureDemo
extends ApplicationFrame {
    public WaterTemperatureDemo(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        NumberAxis numberAxis = new NumberAxis("Temperature");
        numberAxis.setRange(-0.55, -0.15);
        NumberAxis numberAxis2 = new NumberAxis("Depth");
        numberAxis2.setInverted(true);
        numberAxis2.setRange(0.0, 35.0);
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis2, numberAxis, standardXYItemRenderer);
        xYPlot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart jFreeChart = new JFreeChart("Water Temperature By Depth", xYPlot);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Zone 1"));
        xYSeries.add(1.0, -0.5);
        xYSeries.add(5.0, -0.5);
        xYSeries.add(10.0, -0.4);
        xYSeries.add(15.0, -0.4);
        xYSeries.add(20.0, -0.3);
        xYSeries.add(25.0, -0.3);
        xYSeries.add(30.0, -0.2);
        xYSeries.add(35.0, -0.2);
        return new XYSeriesCollection(xYSeries);
    }

    public static void main(String[] stringArray) {
        WaterTemperatureDemo waterTemperatureDemo = new WaterTemperatureDemo("Water Temperature Demo");
        waterTemperatureDemo.pack();
        RefineryUtilities.centerFrameOnScreen(waterTemperatureDemo);
        waterTemperatureDemo.setVisible(true);
    }
}

