/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo8
extends ApplicationFrame {
    public TimeSeriesDemo8(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        TimeSeries timeSeries = DemoDatasetFactory.createEURTimeSeries();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "30 day moving average", 30, 30);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        return timeSeriesCollection;
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Time Series Demo 8", "Date", "Value", xYDataset, true, true, false);
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        StandardXYToolTipGenerator standardXYToolTipGenerator = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00"));
        xYItemRenderer.setToolTipGenerator(standardXYToolTipGenerator);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo8 timeSeriesDemo8 = new TimeSeriesDemo8("Time Series Demo 8");
        timeSeriesDemo8.pack();
        RefineryUtilities.centerFrameOnScreen(timeSeriesDemo8);
        timeSeriesDemo8.setVisible(true);
    }
}

