/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo4
extends ApplicationFrame {
    public TimeSeriesDemo4(String string) {
        super(string);
        Serializable serializable;
        TimeSeries timeSeries = new TimeSeries("Random Data", Hour.class);
        Day day = new Day();
        timeSeries.add((RegularTimePeriod)new Hour(1, day), 500.2);
        timeSeries.add((RegularTimePeriod)new Hour(2, day), 694.1);
        timeSeries.add((RegularTimePeriod)new Hour(3, day), 734.4);
        timeSeries.add((RegularTimePeriod)new Hour(4, day), 453.2);
        timeSeries.add((RegularTimePeriod)new Hour(7, day), 500.2);
        timeSeries.add((RegularTimePeriod)new Hour(8, day), null);
        timeSeries.add((RegularTimePeriod)new Hour(12, day), 734.4);
        timeSeries.add((RegularTimePeriod)new Hour(16, day), 453.2);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa", "Time", "Value", timeSeriesCollection, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ValueMarker valueMarker = new ValueMarker(700.0);
        valueMarker.setPaint(Color.blue);
        valueMarker.setAlpha(0.8f);
        xYPlot.addRangeMarker(valueMarker);
        xYPlot.setBackgroundPaint(null);
        xYPlot.setBackgroundImage(JFreeChart.INFO.getLogo());
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof StandardXYItemRenderer) {
            serializable = (StandardXYItemRenderer)xYItemRenderer;
            ((StandardXYItemRenderer)serializable).setPlotShapes(true);
            ((StandardXYItemRenderer)serializable).setShapesFilled(true);
        }
        serializable = new ChartPanel(jFreeChart);
        ((JComponent)serializable).setPreferredSize(new Dimension(500, 270));
        ((ChartPanel)serializable).setMouseZoomable(true, false);
        this.setContentPane((Container)serializable);
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo4 timeSeriesDemo4 = new TimeSeriesDemo4("Time Series Demo 4");
        timeSeriesDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(timeSeriesDemo4);
        timeSeriesDemo4.setVisible(true);
    }
}

