/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedXYAreaChartDemo
extends ApplicationFrame {
    public StackedXYAreaChartDemo(String string) {
        super(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"), true, false);
        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)"Series 3"), true, false);
        try {
            xYSeries.add((double)simpleDateFormat.parse("03-Jul-2003").getTime(), 115.0);
            xYSeries.add((double)simpleDateFormat.parse("04-Jul-2003").getTime(), 120.0);
            xYSeries.add((double)simpleDateFormat.parse("07-Jul-2003").getTime(), 125.0);
            xYSeries.add((double)simpleDateFormat.parse("08-Jul-2003").getTime(), 160.0);
            xYSeries.add((double)simpleDateFormat.parse("09-Jul-2003").getTime(), 175.0);
            xYSeries.add((double)simpleDateFormat.parse("10-Jul-2003").getTime(), 140.0);
            xYSeries.add((double)simpleDateFormat.parse("11-Jul-2003").getTime(), 145.0);
            xYSeries.add((double)simpleDateFormat.parse("14-Jul-2003").getTime(), 150.0);
            xYSeries.add((double)simpleDateFormat.parse("15-Jul-2003").getTime(), 155.0);
            xYSeries.add((double)simpleDateFormat.parse("16-Jul-2003").getTime(), 160.0);
            xYSeries.add((double)simpleDateFormat.parse("17-Jul-2003").getTime(), 165.0);
            xYSeries.add((double)simpleDateFormat.parse("18-Jul-2003").getTime(), 170.0);
            xYSeries2.add((double)simpleDateFormat.parse("30-Jun-2003").getTime(), 50.0);
            xYSeries2.add((double)simpleDateFormat.parse("01-Jul-2003").getTime(), 60.0);
            xYSeries2.add((double)simpleDateFormat.parse("02-Jul-2003").getTime(), 70.0);
            xYSeries2.add((double)simpleDateFormat.parse("03-Jul-2003").getTime(), 80.0);
            xYSeries2.add((double)simpleDateFormat.parse("04-Jul-2003").getTime(), 90.0);
            xYSeries2.add((double)simpleDateFormat.parse("07-Jul-2003").getTime(), 100.0);
            xYSeries2.add((double)simpleDateFormat.parse("08-Jul-2003").getTime(), 110.0);
            xYSeries2.add((double)simpleDateFormat.parse("09-Jul-2003").getTime(), 120.0);
            xYSeries2.add((double)simpleDateFormat.parse("10-Jul-2003").getTime(), 130.0);
            xYSeries2.add((double)simpleDateFormat.parse("11-Jul-2003").getTime(), 140.0);
            xYSeries2.add((double)simpleDateFormat.parse("14-Jul-2003").getTime(), 150.0);
            xYSeries2.add((double)simpleDateFormat.parse("15-Jul-2003").getTime(), 160.0);
            xYSeries2.add((double)simpleDateFormat.parse("16-Jul-2003").getTime(), 170.0);
            xYSeries2.add((double)simpleDateFormat.parse("17-Jul-2003").getTime(), 180.0);
            xYSeries2.add((double)simpleDateFormat.parse("18-Jul-2003").getTime(), 190.0);
            xYSeries3.add((double)simpleDateFormat.parse("30-Jun-2003").getTime(), 100.0);
            xYSeries3.add((double)simpleDateFormat.parse("01-Jul-2003").getTime(), 120.0);
            xYSeries3.add((double)simpleDateFormat.parse("02-Jul-2003").getTime(), 110.0);
            xYSeries3.add((double)simpleDateFormat.parse("03-Jul-2003").getTime(), 120.0);
            xYSeries3.add((double)simpleDateFormat.parse("04-Jul-2003").getTime(), 130.0);
            xYSeries3.add((double)simpleDateFormat.parse("07-Jul-2003").getTime(), 135.0);
            xYSeries3.add((double)simpleDateFormat.parse("08-Jul-2003").getTime(), 140.0);
            xYSeries3.add((double)simpleDateFormat.parse("09-Jul-2003").getTime(), 155.0);
            xYSeries3.add((double)simpleDateFormat.parse("10-Jul-2003").getTime(), 130.0);
            xYSeries3.add((double)simpleDateFormat.parse("11-Jul-2003").getTime(), 135.0);
            xYSeries3.add((double)simpleDateFormat.parse("14-Jul-2003").getTime(), 140.0);
            xYSeries3.add((double)simpleDateFormat.parse("15-Jul-2003").getTime(), 165.0);
            xYSeries3.add((double)simpleDateFormat.parse("16-Jul-2003").getTime(), 170.0);
            xYSeries3.add((double)simpleDateFormat.parse("17-Jul-2003").getTime(), 165.0);
            xYSeries3.add((double)simpleDateFormat.parse("18-Jul-2003").getTime(), 140.0);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        defaultTableXYDataset.addSeries(xYSeries);
        defaultTableXYDataset.addSeries(xYSeries2);
        defaultTableXYDataset.addSeries(xYSeries3);
        JFreeChart jFreeChart = this.createChart(defaultTableXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(TableXYDataset tableXYDataset) {
        StandardXYToolTipGenerator standardXYToolTipGenerator = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("dd-MMM-yyyy", Locale.UK), NumberFormat.getInstance());
        DateAxis dateAxis = new DateAxis("Domain (X)");
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        NumberAxis numberAxis = new NumberAxis("Range (Y)");
        numberAxis.setAutoRangeIncludesZero(true);
        StackedXYAreaRenderer stackedXYAreaRenderer = new StackedXYAreaRenderer(5, standardXYToolTipGenerator, null);
        stackedXYAreaRenderer.setOutline(true);
        stackedXYAreaRenderer.setSeriesPaint(0, new Color(255, 255, 206));
        stackedXYAreaRenderer.setSeriesPaint(1, new Color(206, 230, 255));
        stackedXYAreaRenderer.setSeriesPaint(2, new Color(255, 230, 230));
        stackedXYAreaRenderer.setShapePaint(Color.gray);
        stackedXYAreaRenderer.setShapeStroke(new BasicStroke(0.5f));
        stackedXYAreaRenderer.setShape(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        XYPlot xYPlot = new XYPlot(tableXYDataset, dateAxis, numberAxis, stackedXYAreaRenderer);
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, true);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedXYAreaChartDemo stackedXYAreaChartDemo = new StackedXYAreaChartDemo("Stacked Area XY Chart Demo");
        stackedXYAreaChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(stackedXYAreaChartDemo);
        stackedXYAreaChartDemo.setVisible(true);
    }
}

