/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedBarChartDemo3
extends ApplicationFrame {
    public StackedBarChartDemo3(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        return DemoDatasetFactory.createCategoryDataset();
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("Stacked Bar Chart Demo 3", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, false, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setLowerMargin(0.15);
        valueAxis.setUpperMargin(0.15);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedBarChartDemo3 stackedBarChartDemo3 = new StackedBarChartDemo3("Stacked Bar Chart Demo 3");
        stackedBarChartDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(stackedBarChartDemo3);
        stackedBarChartDemo3.setVisible(true);
    }
}

