/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class StackedBarChart3DDemo
extends ApplicationFrame {
    public StackedBarChart3DDemo(String string) {
        super(string);
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D("Stacked Bar Chart 3D Demo", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setItemLabelsVisible(true);
        categoryItemRenderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        categoryItemRenderer.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedBarChart3DDemo stackedBarChart3DDemo = new StackedBarChart3DDemo("Stacked Bar Chart 3D Demo");
        stackedBarChart3DDemo.pack();
        RefineryUtilities.centerFrameOnScreen(stackedBarChart3DDemo);
        stackedBarChart3DDemo.setVisible(true);
    }
}

