/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SecondaryDatasetDemo2
extends ApplicationFrame
implements ActionListener {
    private CategoryPlot plot;
    private int secondaryDatasetIndex = 0;

    public SecondaryDatasetDemo2(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createRandomDataset("Series 1");
        JFreeChart jFreeChart = ChartFactory.createLineChart("Secondary Dataset Demo 2", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        this.plot = jFreeChart.getCategoryPlot();
        this.plot.setBackgroundPaint(Color.lightGray);
        this.plot.setDomainGridlinePaint(Color.white);
        this.plot.setRangeGridlinePaint(Color.white);
        NumberAxis numberAxis = (NumberAxis)this.plot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        jPanel.add(chartPanel);
        JButton jButton = new JButton("Add Dataset");
        jButton.setActionCommand("ADD_DATASET");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Remove Dataset");
        jButton2.setActionCommand("REMOVE_DATASET");
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private CategoryDataset createRandomDataset(String string) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        double d = 100.0;
        for (int i = 0; i < 10; ++i) {
            String string2 = "T" + i;
            defaultCategoryDataset.addValue(d *= 1.0 + Math.random() / 100.0, (Comparable)((Object)string), (Comparable)((Object)string2));
        }
        return defaultCategoryDataset;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ADD_DATASET")) {
            if (this.secondaryDatasetIndex < 20) {
                ++this.secondaryDatasetIndex;
                this.plot.setDataset(this.secondaryDatasetIndex, this.createRandomDataset("S" + this.secondaryDatasetIndex));
            }
        } else if (actionEvent.getActionCommand().equals("REMOVE_DATASET") && this.secondaryDatasetIndex > 0) {
            this.plot.setDataset(this.secondaryDatasetIndex, null);
            this.plot.setRenderer(this.secondaryDatasetIndex, null);
            --this.secondaryDatasetIndex;
        }
    }

    public static void main(String[] stringArray) {
        SecondaryDatasetDemo2 secondaryDatasetDemo2 = new SecondaryDatasetDemo2("Secondary Dataset Demo 2");
        secondaryDatasetDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(secondaryDatasetDemo2);
        secondaryDatasetDemo2.setVisible(true);
    }
}

