/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.PolarChartPanel;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PolarChartDemo
extends ApplicationFrame {
    public PolarChartDemo(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        PolarChartPanel polarChartPanel = new PolarChartPanel(jFreeChart);
        polarChartPanel.setPreferredSize(new Dimension(500, 270));
        polarChartPanel.setEnforceFileExtensions(false);
        this.setContentPane(polarChartPanel);
    }

    private XYDataset createDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries xYSeries = PolarChartDemo.createRandomData("Series 1", 75.0, 10.0);
        XYSeries xYSeries2 = PolarChartDemo.createRandomData("Series 2", 50.0, 5.0);
        XYSeries xYSeries3 = PolarChartDemo.createRandomData("Series 3", 25.0, 1.0);
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        xYSeriesCollection.addSeries(xYSeries3);
        return xYSeriesCollection;
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createPolarChart("Polar Chart Demo", xYDataset, true, true, false);
        PolarPlot polarPlot = (PolarPlot)jFreeChart.getPlot();
        DefaultPolarItemRenderer defaultPolarItemRenderer = (DefaultPolarItemRenderer)polarPlot.getRenderer();
        defaultPolarItemRenderer.setSeriesFilled(2, true);
        return jFreeChart;
    }

    private static XYSeries createRandomData(String string, double d, double d2) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        for (double d3 = 0.0; d3 < 360.0; d3 += d2) {
            double d4 = d * (1.0 + Math.random());
            xYSeries.add(d3, d4);
        }
        return xYSeries;
    }

    public static void main(String[] stringArray) {
        PolarChartDemo polarChartDemo = new PolarChartDemo("Polar Chart Demo");
        polarChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(polarChartDemo);
        polarChartDemo.setVisible(true);
    }
}

