/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYImageAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PlotOrientationDemo
extends ApplicationFrame {
    private static final int CHART_COUNT = 8;
    private XYDataset[] datasets = new XYDataset[8];
    private JFreeChart[] charts = new JFreeChart[8];
    private ChartPanel[] panels = new ChartPanel[8];

    public PlotOrientationDemo(String string) {
        super(string);
        JPanel jPanel = new JPanel(new GridLayout(2, 4));
        for (int i = 0; i < 8; ++i) {
            this.datasets[i] = this.createDataset(i);
            this.charts[i] = this.createChart(i, this.datasets[i]);
            XYPlot xYPlot = this.charts[i].getXYPlot();
            XYShapeAnnotation xYShapeAnnotation = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 2.0, 3.0), new BasicStroke(1.0f), Color.blue);
            XYLineAnnotation xYLineAnnotation = new XYLineAnnotation(0.0, -5.0, 10.0, -5.0);
            XYImageAnnotation xYImageAnnotation = new XYImageAnnotation(5.0, 2.0, JFreeChart.INFO.getLogo());
            xYPlot.addAnnotation(xYShapeAnnotation);
            xYPlot.addAnnotation(xYLineAnnotation);
            xYPlot.addAnnotation(xYImageAnnotation);
            xYPlot.setQuadrantPaint(0, new Color(230, 230, 255));
            xYPlot.setQuadrantPaint(1, new Color(230, 255, 230));
            xYPlot.setQuadrantPaint(2, new Color(255, 230, 230));
            xYPlot.setQuadrantPaint(3, new Color(255, 230, 255));
            this.panels[i] = new ChartPanel(this.charts[i]);
        }
        this.charts[1].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[2].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[3].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[3].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[5].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[6].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[4].getXYPlot().getDomainAxis().setInverted(true);
        this.charts[4].getXYPlot().getRangeAxis().setInverted(true);
        this.charts[4].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[5].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[6].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        this.charts[7].getXYPlot().setOrientation(PlotOrientation.HORIZONTAL);
        jPanel.add(this.panels[0]);
        jPanel.add(this.panels[1]);
        jPanel.add(this.panels[4]);
        jPanel.add(this.panels[5]);
        jPanel.add(this.panels[2]);
        jPanel.add(this.panels[3]);
        jPanel.add(this.panels[6]);
        jPanel.add(this.panels[7]);
        jPanel.setPreferredSize(new Dimension(800, 600));
        this.setContentPane(jPanel);
    }

    private XYDataset createDataset(int n) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)("Series " + (n + 1))));
        xYSeries.add(-10.0, -5.0);
        xYSeries.add(10.0, 5.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return xYSeriesCollection;
    }

    private JFreeChart createChart(int n, XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Chart " + (n + 1), "X", "Y", xYDataset, PlotOrientation.VERTICAL, false, false, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYPlot.getRenderer();
        standardXYItemRenderer.setPlotShapes(true);
        standardXYItemRenderer.setShapesFilled(true);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxis valueAxis2 = xYPlot.getRangeAxis();
        valueAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        PlotOrientationDemo plotOrientationDemo = new PlotOrientationDemo("Plot Orientation Demo");
        plotOrientationDemo.pack();
        RefineryUtilities.centerFrameOnScreen(plotOrientationDemo);
        plotOrientationDemo.setVisible(true);
    }
}

