/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PieChartDemo6
extends ApplicationFrame {
    public PieChartDemo6(String string) {
        super(string);
        PieDataset pieDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(pieDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private PieDataset createDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"One"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Two"), new Double(10.0));
        defaultPieDataset.setValue((Comparable)((Object)"Three"), new Double(27.5));
        defaultPieDataset.setValue((Comparable)((Object)"Four"), new Double(17.5));
        defaultPieDataset.setValue((Comparable)((Object)"Five"), new Double(11.0));
        defaultPieDataset.setValue((Comparable)((Object)"Six"), new Double(19.4));
        return defaultPieDataset;
    }

    private JFreeChart createChart(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart("Pie Chart Demo 6", pieDataset, false, true, false);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setLabelGenerator(new CustomLabelGenerator());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        PieChartDemo6 pieChartDemo6 = new PieChartDemo6("Pie Chart Demo 6");
        pieChartDemo6.pack();
        RefineryUtilities.centerFrameOnScreen(pieChartDemo6);
        pieChartDemo6.setVisible(true);
    }

    static class CustomLabelGenerator
    implements PieSectionLabelGenerator {
        CustomLabelGenerator() {
        }

        public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
            String string = null;
            if (pieDataset != null && !comparable.equals("Two")) {
                string = comparable.toString();
            }
            return string;
        }
    }
}

