/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.TableOrder;

public class MultiplePieChartDemo1
extends ApplicationFrame {
    public MultiplePieChartDemo1(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true, true, true, false, true);
        chartPanel.setPreferredSize(new Dimension(600, 380));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{3.0, 4.0, 3.0, 5.0}, {5.0, 7.0, 6.0, 8.0}, {5.0, 7.0, 3.0, 8.0}, {1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 2.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Region ", "Sales/Q", (double[][])dArrayArray);
        return categoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createMultiplePieChart("Multiple Pie Chart", categoryDataset, TableOrder.BY_ROW, true, true, false);
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)jFreeChart.getPlot();
        JFreeChart jFreeChart2 = multiplePiePlot.getPieChart();
        PiePlot piePlot = (PiePlot)jFreeChart2.getPlot();
        piePlot.setLabelGenerator(new StandardPieItemLabelGenerator("{0}"));
        piePlot.setLabelFont(new Font("SansSerif", 0, 8));
        piePlot.setInteriorGap(0.3);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        MultiplePieChartDemo1 multiplePieChartDemo1 = new MultiplePieChartDemo1("Multiple Pie Chart Demo 1");
        multiplePieChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(multiplePieChartDemo1);
        multiplePieChartDemo1.setVisible(true);
    }
}

