/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MultipleAxisDemo1
extends ApplicationFrame {
    public MultipleAxisDemo1(String string) {
        super(string);
        JFreeChart jFreeChart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(600, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart() {
        XYDataset xYDataset = this.createDataset("Series 1", 100.0, new Minute(), 200);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Multiple Axis Demo 1", "Time of Day", "Primary Range Axis", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        jFreeChart.addSubtitle(new TextTitle("Four datasets and four range axes."));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYPlot.getRenderer();
        standardXYItemRenderer.setPaint(Color.black);
        NumberAxis numberAxis = new NumberAxis("Range Axis 2");
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setLabelPaint(Color.red);
        numberAxis.setTickLabelPaint(Color.red);
        xYPlot.setRangeAxis(1, numberAxis);
        xYPlot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        XYDataset xYDataset2 = this.createDataset("Series 2", 1000.0, new Minute(), 170);
        xYPlot.setDataset(1, xYDataset2);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer();
        standardXYItemRenderer2.setSeriesPaint(0, Color.red);
        xYPlot.setRenderer(1, standardXYItemRenderer2);
        NumberAxis numberAxis2 = new NumberAxis("Range Axis 3");
        numberAxis2.setLabelPaint(Color.blue);
        numberAxis2.setTickLabelPaint(Color.blue);
        xYPlot.setRangeAxis(2, numberAxis2);
        XYDataset xYDataset3 = this.createDataset("Series 3", 10000.0, new Minute(), 170);
        xYPlot.setDataset(2, xYDataset3);
        xYPlot.mapDatasetToRangeAxis(2, 2);
        StandardXYItemRenderer standardXYItemRenderer3 = new StandardXYItemRenderer();
        standardXYItemRenderer3.setSeriesPaint(0, Color.blue);
        xYPlot.setRenderer(2, standardXYItemRenderer3);
        NumberAxis numberAxis3 = new NumberAxis("Range Axis 4");
        numberAxis3.setLabelPaint(Color.green);
        numberAxis3.setTickLabelPaint(Color.green);
        xYPlot.setRangeAxis(3, numberAxis3);
        XYDataset xYDataset4 = this.createDataset("Series 4", 25.0, new Minute(), 200);
        xYPlot.setDataset(3, xYDataset4);
        xYPlot.mapDatasetToRangeAxis(3, 3);
        StandardXYItemRenderer standardXYItemRenderer4 = new StandardXYItemRenderer();
        standardXYItemRenderer4.setSeriesPaint(0, Color.green);
        xYPlot.setRenderer(3, standardXYItemRenderer4);
        return jFreeChart;
    }

    private XYDataset createDataset(String string, double d, RegularTimePeriod regularTimePeriod, int n) {
        TimeSeries timeSeries = new TimeSeries(string, regularTimePeriod.getClass());
        RegularTimePeriod regularTimePeriod2 = regularTimePeriod;
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod2, d2);
            regularTimePeriod2 = regularTimePeriod2.next();
            d2 *= 1.0 + (Math.random() - 0.495) / 10.0;
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    public static void main(String[] stringArray) {
        MultipleAxisDemo1 multipleAxisDemo1 = new MultipleAxisDemo1("Multiple Axis Demo 1");
        multipleAxisDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(multipleAxisDemo1);
        multipleAxisDemo1.setVisible(true);
    }
}

