/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.ui.RefineryUtilities;

public class MeterChartDemo {
    void displayMeterChart(double d, DialShape dialShape) {
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(75.0);
        MeterPlot meterPlot = new MeterPlot(defaultValueDataset);
        meterPlot.setUnits("Degrees");
        meterPlot.setRange(new Range(20.0, 140.0));
        meterPlot.setDialShape(dialShape);
        meterPlot.setNeedlePaint(Color.white);
        meterPlot.setTickLabelFont(new Font("SansSerif", 1, 9));
        JFreeChart jFreeChart = new JFreeChart("Meter Chart", JFreeChart.DEFAULT_TITLE_FONT, meterPlot, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame("Meter Chart", jFreeChart);
        chartFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly(chartFrame);
        chartFrame.setSize(250, 250);
        chartFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java TestMeter <type> <value>");
            System.err.println("Type:  0 = PIE");
            System.err.println("Type:  1 = CIRCLE");
            System.err.println("Type:  2 = CHORD");
        }
        MeterChartDemo meterChartDemo = new MeterChartDemo();
        double d = 85.0;
        DialShape dialShape = DialShape.CIRCLE;
        if (stringArray.length > 0) {
            int n = Integer.parseInt(stringArray[0]);
            if (n == 0) {
                dialShape = DialShape.PIE;
            } else if (n == 1) {
                dialShape = DialShape.CIRCLE;
            } else if (n == 0) {
                dialShape = DialShape.CHORD;
            }
        }
        if (stringArray.length > 1) {
            d = new Double(stringArray[1]);
        }
        meterChartDemo.displayMeterChart(d, dialShape);
    }
}

