/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.util.TableOrder;

public class ImageMapDemo6 {
    public void saveImageAndHTML() {
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo(new StandardEntityCollection());
            File file = new File("multipiechart100.png");
            ChartUtilities.saveChartAsPNG(file, jFreeChart, 600, 400, chartRenderingInfo);
            File file2 = new File("multipiechart100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<HTML>");
            printWriter.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("<IMG SRC=\"multipiechart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{3.0, 4.0, 3.0, 5.0}, {5.0, 7.0, 6.0, 8.0}, {5.0, 7.0, 3.0, 8.0}, {1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 2.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Region ", "Sales/Q", (double[][])dArrayArray);
        return categoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createMultiplePieChart("Multiple Pie Chart", categoryDataset, TableOrder.BY_ROW, true, true, true);
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)jFreeChart.getPlot();
        JFreeChart jFreeChart2 = multiplePiePlot.getPieChart();
        PiePlot piePlot = (PiePlot)jFreeChart2.getPlot();
        piePlot.setLabelGenerator(new StandardPieItemLabelGenerator("{0}"));
        piePlot.setLabelFont(new Font("SansSerif", 0, 8));
        piePlot.setInteriorGap(0.3);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        ImageMapDemo6 imageMapDemo6 = new ImageMapDemo6();
        imageMapDemo6.saveImageAndHTML();
    }
}

