/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

public class ImageMapDemo5 {
    public void saveImageAndHTML() {
        double[][] dArrayArray = new double[][]{{56.0, -12.0, 34.0, 76.0, 56.0, 100.0, 67.0, 45.0}, {37.0, 45.0, 67.0, 25.0, 34.0, 34.0, 100.0, 53.0}, {43.0, 54.0, 34.0, 34.0, 87.0, 64.0, 73.0, 12.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])dArrayArray);
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo(new StandardEntityCollection());
            File file = new File("areachart100.png");
            ChartUtilities.saveChartAsPNG(file, jFreeChart, 600, 400, chartRenderingInfo);
            File file2 = new File("areachart100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<HTML>");
            printWriter.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("<IMG SRC=\"areachart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createAreaChart("Area Chart", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        TextTitle textTitle = new TextTitle("An area chart demonstration.  We use this subtitle  as an example of what happens when you get a really long title or subtitle.");
        textTitle.setFont(new Font("SansSerif", 0, 12));
        textTitle.setPosition(RectangleEdge.TOP);
        textTitle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        jFreeChart.addSubtitle(textTitle);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setForegroundAlpha(0.5f);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint(Color.white);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setLabelAngle(0.0);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        ImageMapDemo5 imageMapDemo5 = new ImageMapDemo5();
        imageMapDemo5.saveImageAndHTML();
    }
}

