/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HistogramDemo2
extends ApplicationFrame {
    public HistogramDemo2(String string) {
        super(string);
        IntervalXYDataset intervalXYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(intervalXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private IntervalXYDataset createDataset() {
        HistogramDataset histogramDataset = new HistogramDataset();
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        histogramDataset.addSeries((Comparable)((Object)"H1"), dArray, 10, 0.0, 10.0);
        return histogramDataset;
    }

    private JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createHistogram("Histogram Demo", null, null, intervalXYDataset, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    public static void main(String[] stringArray) throws IOException {
        HistogramDemo2 histogramDemo2 = new HistogramDemo2("Histogram Demo 2");
        histogramDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(histogramDemo2);
        histogramDemo2.setVisible(true);
    }
}

