/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HighLowChartDemo2
extends ApplicationFrame {
    public HighLowChartDemo2(String string) {
        super(string);
        DefaultHighLowDataset defaultHighLowDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(defaultHighLowDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private DefaultHighLowDataset createDataset() {
        return DemoDatasetFactory.createHighLowDataset();
    }

    private JFreeChart createChart(DefaultHighLowDataset defaultHighLowDataset) {
        JFreeChart jFreeChart = ChartFactory.createHighLowChart("OHLC Demo 2", "Time", "Value", defaultHighLowDataset, true);
        DateAxis dateAxis = (DateAxis)jFreeChart.getXYPlot().getDomainAxis();
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        XYDataset xYDataset = MovingAverage.createMovingAverage((XYDataset)defaultHighLowDataset, "-MAVG", 259200000L, 0L);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setDataset(1, xYDataset);
        xYPlot.setRenderer(1, new StandardXYItemRenderer());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        HighLowChartDemo2 highLowChartDemo2 = new HighLowChartDemo2("OHLC Demo 2");
        highLowChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(highLowChartDemo2);
        highLowChartDemo2.setVisible(true);
    }
}

