/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo4
extends ApplicationFrame {
    public DualAxisDemo4(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset1();
        JFreeChart jFreeChart = ChartFactory.createBarChart3D("Dual Axis Chart", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new Color(204, 255, 204));
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        categoryPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setSeriesPaint(0, Color.red);
        categoryItemRenderer.setSeriesPaint(1, Color.yellow);
        categoryItemRenderer.setSeriesPaint(2, Color.green);
        CategoryDataset categoryDataset2 = this.createDataset2();
        NumberAxis3D numberAxis3D = new NumberAxis3D("Secondary");
        categoryPlot.setRangeAxis(1, numberAxis3D);
        categoryPlot.setDataset(1, categoryDataset2);
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setSeriesPaint(0, Color.blue);
        categoryPlot.setRenderer(1, lineAndShapeRenderer);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        return defaultCategoryDataset;
    }

    private CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(24.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(31.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(25.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(56.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 5"));
        return defaultCategoryDataset;
    }

    public static void main(String[] stringArray) {
        DualAxisDemo4 dualAxisDemo4 = new DualAxisDemo4("Dual Axis Demo 4");
        dualAxisDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(dualAxisDemo4);
        dualAxisDemo4.setVisible(true);
    }
}

