/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo3
extends ApplicationFrame {
    public DualAxisDemo3(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset1();
        JFreeChart jFreeChart = ChartFactory.createBarChart("Dual Axis Chart", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(new Color(204, 255, 204));
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        CategoryDataset categoryDataset2 = this.createDataset2();
        NumberAxis numberAxis = new NumberAxis("Secondary");
        categoryPlot.setRangeAxis(1, numberAxis);
        categoryPlot.setDataset(1, categoryDataset2);
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        categoryPlot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        categoryPlot.setRenderer(1, lineAndShapeRenderer);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 8"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 8"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 8"));
        return defaultCategoryDataset;
    }

    private CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(24.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(31.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(25.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(56.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(37.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(77.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(18.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 8"));
        return defaultCategoryDataset;
    }

    public static void main(String[] stringArray) {
        DualAxisDemo3 dualAxisDemo3 = new DualAxisDemo3("Dual Axis Demo 3");
        dualAxisDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(dualAxisDemo3);
        dualAxisDemo3.setVisible(true);
    }
}

