/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CombinedXYPlotDemo3
extends ApplicationFrame {
    public CombinedXYPlotDemo3(String string) {
        super(string);
        JFreeChart jFreeChart = this.createCombinedChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true, true, true, false, true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createCombinedChart() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = DemoDatasetFactory.createEURTimeSeries();
        timeSeriesCollection.addSeries(timeSeries);
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "EUR/GBP (30 Day MA)", 30, 30);
        timeSeriesCollection2.addSeries(timeSeries);
        timeSeriesCollection2.addSeries(timeSeries2);
        TimeSeriesCollection timeSeriesCollection3 = new TimeSeriesCollection();
        timeSeriesCollection3.addSeries(timeSeries);
        JFreeChart jFreeChart = null;
        NumberAxis numberAxis = new NumberAxis("Value");
        numberAxis.setAutoRangeIncludesZero(false);
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot(numberAxis);
        XYPlot xYPlot = new XYPlot(timeSeriesCollection, new DateAxis("Date 1"), null, new StandardXYItemRenderer());
        combinedRangeXYPlot.add(xYPlot, 1);
        XYPlot xYPlot2 = new XYPlot(timeSeriesCollection2, new DateAxis("Date 2"), null, new StandardXYItemRenderer());
        combinedRangeXYPlot.add(xYPlot2, 1);
        XYPlot xYPlot3 = new XYPlot(timeSeriesCollection3, new DateAxis("Date 3"), null, new XYBarRenderer(0.2));
        combinedRangeXYPlot.add(xYPlot3, 1);
        jFreeChart = new JFreeChart("Demo Chart", JFreeChart.DEFAULT_TITLE_FONT, combinedRangeXYPlot, true);
        TextTitle textTitle = new TextTitle("This is a subtitle", new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        CombinedXYPlotDemo3 combinedXYPlotDemo3 = new CombinedXYPlotDemo3("Combined XY Plot Demo 3");
        combinedXYPlotDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(combinedXYPlotDemo3);
        combinedXYPlotDemo3.setVisible(true);
    }
}

