/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class BarChartDemo7
extends ApplicationFrame {
    public BarChartDemo7(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Bar Chart Demo 7", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinePaint(Color.white);
        IntervalMarker intervalMarker = new IntervalMarker(4.5, 7.5);
        intervalMarker.setLabel("Target Range");
        intervalMarker.setLabelFont(new Font("SansSerif", 2, 11));
        intervalMarker.setLabelAnchor(RectangleAnchor.LEFT);
        intervalMarker.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
        intervalMarker.setPaint(new Color(222, 222, 255, 128));
        categoryPlot.addRangeMarker(intervalMarker, Layer.BACKGROUND);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        barRenderer.setItemMargin(0.1);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gradientPaint3 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.lightGray);
        barRenderer.setSeriesPaint(0, gradientPaint);
        barRenderer.setSeriesPaint(1, gradientPaint2);
        barRenderer.setSeriesPaint(2, gradientPaint3);
        barRenderer.setItemLabelsVisible(true);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966);
        barRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        ItemLabelPosition itemLabelPosition2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966);
        barRenderer.setPositiveItemLabelPositionFallback(itemLabelPosition2);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        TextUtilities.setUseFontMetricsGetStringBounds(false);
        BarChartDemo7 barChartDemo7 = new BarChartDemo7("Bar Chart Demo 7");
        barChartDemo7.pack();
        RefineryUtilities.centerFrameOnScreen(barChartDemo7);
        barChartDemo7.setVisible(true);
    }
}

