/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.FlowArrangement;

public class BlockContainerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BlockContainerTests.class);
    }

    public BlockContainerTests(String string) {
        super(string);
    }

    public void testEquals() {
        BlockContainer blockContainer = new BlockContainer(new FlowArrangement());
        BlockContainer blockContainer2 = new BlockContainer(new FlowArrangement());
        BlockContainerTests.assertTrue((boolean)blockContainer.equals(blockContainer2));
        BlockContainerTests.assertTrue((boolean)blockContainer2.equals(blockContainer2));
        blockContainer.setArrangement(new ColumnArrangement());
        BlockContainerTests.assertFalse((boolean)blockContainer.equals(blockContainer2));
        blockContainer2.setArrangement(new ColumnArrangement());
        BlockContainerTests.assertTrue((boolean)blockContainer.equals(blockContainer2));
        blockContainer.add(new EmptyBlock(1.2, 3.4));
        BlockContainerTests.assertFalse((boolean)blockContainer.equals(blockContainer2));
        blockContainer2.add(new EmptyBlock(1.2, 3.4));
        BlockContainerTests.assertTrue((boolean)blockContainer.equals(blockContainer2));
    }

    public void testCloning() {
        BlockContainer blockContainer = new BlockContainer(new FlowArrangement());
        blockContainer.add(new EmptyBlock(1.2, 3.4));
        BlockContainer blockContainer2 = null;
        try {
            blockContainer2 = (BlockContainer)blockContainer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        BlockContainerTests.assertTrue((blockContainer != blockContainer2 ? 1 : 0) != 0);
        BlockContainerTests.assertTrue((blockContainer.getClass() == blockContainer2.getClass() ? 1 : 0) != 0);
        BlockContainerTests.assertTrue((boolean)blockContainer.equals(blockContainer2));
    }

    public void testSerialization() {
        BlockContainer blockContainer = new BlockContainer();
        blockContainer.add(new EmptyBlock(1.2, 3.4));
        BlockContainer blockContainer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(blockContainer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            blockContainer2 = (BlockContainer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            BlockContainerTests.fail((String)exception.toString());
        }
        BlockContainerTests.assertEquals((Object)blockContainer, blockContainer2);
    }
}

