/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.axis.junit.CategoryAxisTests;

public class SubCategoryAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryAxisTests.class);
    }

    public SubCategoryAxisTests(String string) {
        super(string);
    }

    public void testEquals() {
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("Test");
        SubCategoryAxis subCategoryAxis2 = new SubCategoryAxis("Test");
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis2.equals(subCategoryAxis));
        subCategoryAxis.addSubCategory((Comparable)((Object)"Sub 1"));
        SubCategoryAxisTests.assertFalse((boolean)subCategoryAxis.equals(subCategoryAxis2));
        subCategoryAxis2.addSubCategory((Comparable)((Object)"Sub 1"));
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
        subCategoryAxis.setSubLabelFont(new Font("Serif", 1, 15));
        SubCategoryAxisTests.assertFalse((boolean)subCategoryAxis.equals(subCategoryAxis2));
        subCategoryAxis2.setSubLabelFont(new Font("Serif", 1, 15));
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
        subCategoryAxis.setSubLabelPaint(Color.red);
        SubCategoryAxisTests.assertFalse((boolean)subCategoryAxis.equals(subCategoryAxis2));
        subCategoryAxis2.setSubLabelPaint(Color.red);
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
    }

    public void testHashCode() {
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("Test");
        SubCategoryAxis subCategoryAxis2 = new SubCategoryAxis("Test");
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
        int n = subCategoryAxis.hashCode();
        int n2 = subCategoryAxis2.hashCode();
        SubCategoryAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("Test");
        SubCategoryAxis subCategoryAxis2 = null;
        try {
            subCategoryAxis2 = (SubCategoryAxis)subCategoryAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        SubCategoryAxisTests.assertTrue((subCategoryAxis != subCategoryAxis2 ? 1 : 0) != 0);
        SubCategoryAxisTests.assertTrue((subCategoryAxis.getClass() == subCategoryAxis2.getClass() ? 1 : 0) != 0);
        SubCategoryAxisTests.assertTrue((boolean)subCategoryAxis.equals(subCategoryAxis2));
    }

    public void testSerialization() {
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("Test Axis");
        SubCategoryAxis subCategoryAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(subCategoryAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            subCategoryAxis2 = (SubCategoryAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SubCategoryAxisTests.assertEquals((Object)subCategoryAxis, subCategoryAxis2);
    }
}

