/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.SegmentedTimeline;

public class SegmentedTimelineTests
extends TestCase {
    private static final int TEST_CYCLE_START = 0;
    private static final int TEST_CYCLE_END = 1000;
    private static final int TEST_CYCLE_INC = 55;
    private static final long FIVE_YEARS = 157680000000L;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final SimpleDateFormat DATE_FORMAT;
    private static final SimpleDateFormat DATE_TIME_FORMAT;
    private static final String[] MS_EXCEPTIONS;
    private static final String[] MS2_BASE_TIMELINE_EXCEPTIONS;
    private static final String[] US_HOLIDAYS;
    private static final String[] FIFTEEN_MIN_EXCEPTIONS;
    private SegmentedTimeline msTimeline;
    private SegmentedTimeline ms2Timeline;
    private SegmentedTimeline ms2BaseTimeline;
    private SegmentedTimeline mondayFridayTimeline;
    private SegmentedTimeline fifteenMinTimeline;
    private Calendar monday;
    private Calendar monday9am;

    public static Test suite() {
        return new TestSuite(SegmentedTimelineTests.class);
    }

    public SegmentedTimelineTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.msTimeline = new SegmentedTimeline(1L, 5, 2);
        this.msTimeline.setStartTime(0L);
        this.ms2BaseTimeline = new SegmentedTimeline(4L, 1, 1);
        this.ms2BaseTimeline.setStartTime(0L);
        this.ms2Timeline = new SegmentedTimeline(1L, 2, 2);
        this.ms2Timeline.setStartTime(1L);
        this.ms2Timeline.setBaseTimeline(this.ms2BaseTimeline);
        this.mondayFridayTimeline = SegmentedTimeline.newMondayThroughFridayTimeline();
        this.fifteenMinTimeline = SegmentedTimeline.newFifteenMinuteTimeline();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(SegmentedTimeline.NO_DST_TIME_ZONE);
        gregorianCalendar.set(2001, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        this.monday = (Calendar)((Calendar)gregorianCalendar).clone();
        ((Calendar)gregorianCalendar).add(10, 9);
        this.monday9am = (Calendar)((Calendar)gregorianCalendar).clone();
    }

    protected void tearDown() throws Exception {
    }

    public void testMsSegmentedTimeline() {
        SegmentedTimelineTests.assertEquals((long)1L, (long)this.msTimeline.getSegmentSize());
        SegmentedTimelineTests.assertEquals((long)0L, (long)this.msTimeline.getStartTime());
        SegmentedTimelineTests.assertEquals((int)5, (int)this.msTimeline.getSegmentsIncluded());
        SegmentedTimelineTests.assertEquals((int)2, (int)this.msTimeline.getSegmentsExcluded());
    }

    public void testMs2SegmentedTimeline() {
        SegmentedTimelineTests.assertEquals((long)1L, (long)this.ms2Timeline.getSegmentSize());
        SegmentedTimelineTests.assertEquals((long)1L, (long)this.ms2Timeline.getStartTime());
        SegmentedTimelineTests.assertEquals((int)2, (int)this.ms2Timeline.getSegmentsIncluded());
        SegmentedTimelineTests.assertEquals((int)2, (int)this.ms2Timeline.getSegmentsExcluded());
        SegmentedTimelineTests.assertEquals((Object)this.ms2BaseTimeline, (Object)this.ms2Timeline.getBaseTimeline());
    }

    public void testMondayThroughFridaySegmentedTimeline() {
        SegmentedTimelineTests.assertEquals((long)86400000L, (long)this.mondayFridayTimeline.getSegmentSize());
        SegmentedTimelineTests.assertEquals((long)SegmentedTimeline.FIRST_MONDAY_AFTER_1900, (long)this.mondayFridayTimeline.getStartTime());
        SegmentedTimelineTests.assertEquals((int)5, (int)this.mondayFridayTimeline.getSegmentsIncluded());
        SegmentedTimelineTests.assertEquals((int)2, (int)this.mondayFridayTimeline.getSegmentsExcluded());
    }

    public void testFifteenMinSegmentedTimeline() {
        SegmentedTimelineTests.assertEquals((long)900000L, (long)this.fifteenMinTimeline.getSegmentSize());
        SegmentedTimelineTests.assertEquals((long)(SegmentedTimeline.FIRST_MONDAY_AFTER_1900 + 36L * this.fifteenMinTimeline.getSegmentSize()), (long)this.fifteenMinTimeline.getStartTime());
        SegmentedTimelineTests.assertEquals((int)28, (int)this.fifteenMinTimeline.getSegmentsIncluded());
        SegmentedTimelineTests.assertEquals((int)68, (int)this.fifteenMinTimeline.getSegmentsExcluded());
    }

    public void testMsSegment() {
        this.verifyOneSegment(this.msTimeline);
    }

    public void testMs2Segment() {
        this.verifyOneSegment(this.ms2Timeline);
    }

    public void testMondayThroughFridaySegment() {
        this.verifyOneSegment(this.mondayFridayTimeline);
    }

    public void testFifteenMinSegment() {
        this.verifyOneSegment(this.fifteenMinTimeline);
    }

    public void verifyOneSegment(SegmentedTimeline segmentedTimeline) {
        for (long i = 0L; i < 1000L; i += 55L) {
            SegmentedTimeline.Segment segment;
            SegmentedTimeline.Segment segment2 = segmentedTimeline.getSegment(this.monday.getTime().getTime() + i);
            SegmentedTimeline.Segment segment3 = segmentedTimeline.getSegment(segment2.getSegmentEnd() + 1L);
            SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentNumber() + 1L), (long)segment3.getSegmentNumber());
            SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentEnd() + 1L), (long)segment3.getSegmentStart());
            SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentStart() + segmentedTimeline.getSegmentSize() - 1L), (long)segment2.getSegmentEnd());
            SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentStart() + segmentedTimeline.getSegmentSize()), (long)segment3.getSegmentStart());
            SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentEnd() + segmentedTimeline.getSegmentSize()), (long)segment3.getSegmentEnd());
            long l = segmentedTimeline.getSegmentSize() > 1000000L ? segmentedTimeline.getSegmentSize() / 10000L : (segmentedTimeline.getSegmentSize() > 100000L ? segmentedTimeline.getSegmentSize() / 1000L : (segmentedTimeline.getSegmentSize() > 10000L ? segmentedTimeline.getSegmentSize() / 100L : (segmentedTimeline.getSegmentSize() > 1000L ? segmentedTimeline.getSegmentSize() / 10L : (segmentedTimeline.getSegmentSize() > 100L ? segmentedTimeline.getSegmentSize() / 5L : 1L))));
            long l2 = segment2.getSegmentStart() + l;
            long l3 = segment2.getSegmentStart() + segmentedTimeline.getSegmentSize() - 1L;
            SegmentedTimeline.Segment segment4 = segmentedTimeline.getSegment(segment2.getSegmentStart());
            for (long j = l2; j < l3; j += l) {
                segment = segmentedTimeline.getSegment(j);
                SegmentedTimelineTests.assertEquals((long)segment4.getSegmentNumber(), (long)segment.getSegmentNumber());
                SegmentedTimelineTests.assertEquals((long)segment4.getSegmentStart(), (long)segment.getSegmentStart());
                SegmentedTimelineTests.assertEquals((long)segment4.getSegmentEnd(), (long)segment.getSegmentEnd());
                SegmentedTimelineTests.assertTrue((segment4.getMillisecond() < segment.getMillisecond() ? 1 : 0) != 0);
                segment4 = segment;
            }
            segment = segmentedTimeline.getSegment(l3 + 1L);
            SegmentedTimelineTests.assertEquals((long)segment3.getSegmentNumber(), (long)segment.getSegmentNumber());
            SegmentedTimelineTests.assertEquals((long)segment3.getSegmentStart(), (long)segment.getSegmentStart());
            SegmentedTimelineTests.assertEquals((long)segment3.getSegmentEnd(), (long)segment.getSegmentEnd());
        }
    }

    public void testMsInc() {
        this.verifyInc(this.msTimeline);
    }

    public void testMs2Inc() {
        this.verifyInc(this.ms2Timeline);
    }

    public void testMondayThroughFridayInc() {
        this.verifyInc(this.mondayFridayTimeline);
    }

    public void testFifteenMinInc() {
        this.verifyInc(this.fifteenMinTimeline);
    }

    public void verifyInc(SegmentedTimeline segmentedTimeline) {
        for (long i = 0L; i < 1000L; i += 55L) {
            long l = segmentedTimeline.getSegmentSize();
            SegmentedTimeline.Segment segment = segmentedTimeline.getSegment(i);
            SegmentedTimeline.Segment segment2 = segment.copy();
            for (int j = 0; j < 1000; ++j) {
                SegmentedTimeline.Segment segment3 = segment2.copy();
                segment3.inc();
                if (segment2.getSegmentEnd() + 1L != segment3.getSegmentStart()) {
                    SegmentedTimelineTests.assertTrue((!segmentedTimeline.containsDomainRange(segment2.getSegmentEnd() + 1L, segment3.getSegmentStart() - 1L) ? 1 : 0) != 0);
                    SegmentedTimelineTests.assertEquals((long)0L, (long)((segment3.getSegmentStart() - segment2.getSegmentStart()) % l));
                    SegmentedTimelineTests.assertEquals((long)0L, (long)((segment3.getSegmentEnd() - segment2.getSegmentEnd()) % l));
                    SegmentedTimelineTests.assertEquals((long)0L, (long)((segment3.getMillisecond() - segment2.getMillisecond()) % l));
                } else {
                    SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentStart() + l), (long)segment3.getSegmentStart());
                    SegmentedTimelineTests.assertEquals((long)(segment2.getSegmentEnd() + l), (long)segment3.getSegmentEnd());
                    SegmentedTimelineTests.assertEquals((long)(segment2.getMillisecond() + l), (long)segment3.getMillisecond());
                }
                SegmentedTimeline.Segment segment4 = segment2.copy();
                SegmentedTimeline.Segment segment5 = segment2.copy();
                for (int k = 0; k < j; ++k) {
                    segment4.inc();
                }
                segment5.inc(j);
                SegmentedTimelineTests.assertEquals((long)segment4.getSegmentStart(), (long)segment5.getSegmentStart());
                SegmentedTimelineTests.assertEquals((long)segment4.getSegmentEnd(), (long)segment5.getSegmentEnd());
                SegmentedTimelineTests.assertEquals((long)segment4.getMillisecond(), (long)segment5.getMillisecond());
                segment2.inc();
            }
        }
    }

    public void testMsIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.msTimeline, 0L);
    }

    public void testMs2IncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.ms2Timeline, 1L);
    }

    public void testMondayThroughFridayIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.mondayFridayTimeline, this.monday.getTime().getTime());
    }

    public void testFifteenMinIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.fifteenMinTimeline, this.monday9am.getTime().getTime());
    }

    public void verifyIncludedAndExcludedSegments(SegmentedTimeline segmentedTimeline, long l) {
        segmentedTimeline.setExceptionSegments(new ArrayList());
        SegmentedTimeline.Segment segment = segmentedTimeline.getSegment(l);
        for (int i = 0; i < 1000; ++i) {
            int n = i % segmentedTimeline.getGroupSegmentCount();
            if (n < segmentedTimeline.getSegmentsIncluded()) {
                SegmentedTimelineTests.assertTrue((boolean)segment.inIncludeSegments());
                SegmentedTimelineTests.assertTrue((!segment.inExcludeSegments() ? 1 : 0) != 0);
                SegmentedTimelineTests.assertTrue((!segment.inExceptionSegments() ? 1 : 0) != 0);
            } else {
                SegmentedTimelineTests.assertTrue((!segment.inIncludeSegments() ? 1 : 0) != 0);
                SegmentedTimelineTests.assertTrue((boolean)segment.inExcludeSegments());
                SegmentedTimelineTests.assertTrue((!segment.inExceptionSegments() ? 1 : 0) != 0);
            }
            segment.inc();
        }
    }

    public void testMsExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.msTimeline, MS_EXCEPTIONS, NUMBER_FORMAT);
    }

    public void testMs2BaseTimelineExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.ms2BaseTimeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
    }

    public void testMondayThoughFridayExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.mondayFridayTimeline, US_HOLIDAYS, DATE_FORMAT);
    }

    public void testFifteenMinExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.fifteenMinTimeline, FIFTEEN_MIN_EXCEPTIONS, DATE_TIME_FORMAT);
    }

    public void verifyExceptionSegments(SegmentedTimeline segmentedTimeline, String[] stringArray, Format format) throws ParseException {
        long[] lArray = this.verifyFillInExceptions(segmentedTimeline, stringArray, format);
        int n = lArray.length;
        SegmentedTimelineTests.assertEquals((int)lArray.length, (int)segmentedTimeline.getExceptionSegments().size());
        SegmentedTimeline.Segment segment = segmentedTimeline.getSegment(lArray[n - 1]);
        for (int i = 0; i < n; ++i) {
            SegmentedTimeline.Segment segment2 = segmentedTimeline.getSegment(lArray[i]);
            SegmentedTimelineTests.assertTrue((boolean)segment2.inExceptionSegments());
            SegmentedTimelineTests.assertEquals((long)(n - i), (long)segmentedTimeline.getExceptionSegmentCount(segment2.getSegmentStart(), segment.getSegmentEnd()));
            SegmentedTimelineTests.assertEquals((long)Math.max(0, n - i - 2), (long)segmentedTimeline.getExceptionSegmentCount(lArray[i] + 1L, lArray[n - 1] - 1L));
        }
    }

    public void testMsTranslations() throws ParseException {
        this.verifyFillInExceptions(this.msTimeline, MS_EXCEPTIONS, NUMBER_FORMAT);
        this.verifyTranslations(this.msTimeline, 0L);
    }

    public void testMs2BaseTimelineTranslations() throws ParseException {
        this.verifyFillInExceptions(this.ms2BaseTimeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
        this.verifyTranslations(this.ms2BaseTimeline, 0L);
    }

    public void testMs2Translations() throws ParseException {
        this.fillInBaseTimelineExceptions(this.ms2Timeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
        this.fillInBaseTimelineExclusionsAsExceptions(this.ms2Timeline, 0L, 5000L);
        this.verifyTranslations(this.ms2Timeline, 1L);
    }

    public void testMondayThroughFridayTranslations() throws ParseException {
        this.verifyFillInExceptions(this.mondayFridayTimeline, US_HOLIDAYS, DATE_FORMAT);
        this.verifyTranslations(this.mondayFridayTimeline, this.monday.getTime().getTime());
    }

    public void testFifteenMinTranslations() throws ParseException {
        this.verifyFillInExceptions(this.fifteenMinTimeline, FIFTEEN_MIN_EXCEPTIONS, DATE_TIME_FORMAT);
        this.fillInBaseTimelineExceptions(this.fifteenMinTimeline, US_HOLIDAYS, DATE_FORMAT);
        this.fillInBaseTimelineExclusionsAsExceptions(this.fifteenMinTimeline, this.monday9am.getTime().getTime(), this.monday9am.getTime().getTime() + 157680000000L);
        this.verifyTranslations(this.fifteenMinTimeline, this.monday9am.getTime().getTime());
    }

    public void verifyTranslations(SegmentedTimeline segmentedTimeline, long l) {
        for (long i = 0L; i < 1000L; i += 55L) {
            long l2 = l + i * segmentedTimeline.getSegmentSize();
            SegmentedTimeline.Segment segment = segmentedTimeline.getSegment(l2);
            for (int j = 0; j < 1000; ++j) {
                long l3 = segmentedTimeline.toTimelineValue(segment.getMillisecond());
                long l4 = segmentedTimeline.toMillisecond(l3);
                if (segment.inExcludeSegments() || segment.inExceptionSegments()) {
                    SegmentedTimeline.Segment segment2 = segment.copy();
                    segment2.moveIndexToStart();
                    do {
                        segment2.inc();
                    } while (!segment2.inIncludeSegments());
                    SegmentedTimelineTests.assertEquals((long)segment2.getMillisecond(), (long)l4);
                } else {
                    SegmentedTimelineTests.assertEquals((long)segment.getMillisecond(), (long)l4);
                }
                segment.inc();
            }
        }
    }

    public void testSerialization() {
        this.verifySerialization(this.msTimeline);
        this.verifySerialization(this.ms2Timeline);
        this.verifySerialization(this.ms2BaseTimeline);
        this.verifySerialization(SegmentedTimeline.newMondayThroughFridayTimeline());
        this.verifySerialization(SegmentedTimeline.newFifteenMinuteTimeline());
    }

    private void verifySerialization(SegmentedTimeline segmentedTimeline) {
        SegmentedTimeline segmentedTimeline2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(segmentedTimeline);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            segmentedTimeline2 = (SegmentedTimeline)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SegmentedTimelineTests.assertEquals((Object)segmentedTimeline, segmentedTimeline2);
    }

    private long[] verifyFillInExceptions(SegmentedTimeline segmentedTimeline, String[] stringArray, Format format) throws ParseException {
        segmentedTimeline.setExceptionSegments(new ArrayList());
        SegmentedTimelineTests.assertEquals((int)0, (int)segmentedTimeline.getExceptionSegments().size());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < stringArray.length; ++i) {
            long l = format instanceof NumberFormat ? ((NumberFormat)format).parse(stringArray[i]).longValue() : segmentedTimeline.getTime(((SimpleDateFormat)format).parse(stringArray[i]));
            SegmentedTimeline.Segment comparable = segmentedTimeline.getSegment(l);
            if (!comparable.inIncludeSegments()) continue;
            segmentedTimeline.addException(l);
            arrayList.add(new Long(l));
            SegmentedTimelineTests.assertEquals((int)arrayList.size(), (int)segmentedTimeline.getExceptionSegments().size());
            SegmentedTimelineTests.assertTrue((boolean)comparable.inExceptionSegments());
        }
        long[] lArray = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            lArray[n++] = l;
        }
        return lArray;
    }

    private void fillInBaseTimelineExceptions(SegmentedTimeline segmentedTimeline, String[] stringArray, Format format) throws ParseException {
        SegmentedTimeline segmentedTimeline2 = segmentedTimeline.getBaseTimeline();
        for (int i = 0; i < stringArray.length; ++i) {
            long l = format instanceof NumberFormat ? ((NumberFormat)format).parse(stringArray[i]).longValue() : segmentedTimeline.getTime(((SimpleDateFormat)format).parse(stringArray[i]));
            segmentedTimeline.addBaseTimelineException(l);
            SegmentedTimeline.Segment segment = segmentedTimeline2.getSegment(l);
            SegmentedTimeline.Segment segment2 = segmentedTimeline.getSegment(segment.getSegmentStart());
            while (segment2.getSegmentStart() <= segment.getSegmentEnd()) {
                if (!segment2.inExcludeSegments()) {
                    SegmentedTimelineTests.assertTrue((boolean)segment2.inExceptionSegments());
                }
                segment2.inc();
            }
        }
    }

    private void fillInBaseTimelineExclusionsAsExceptions(SegmentedTimeline segmentedTimeline, long l, long l2) {
        segmentedTimeline.addBaseTimelineExclusions(l, l2);
        SegmentedTimeline.Segment segment = segmentedTimeline.getBaseTimeline().getSegment(l);
        while (segment.getSegmentStart() <= l2) {
            if (segment.inExcludeSegments()) {
                SegmentedTimeline.Segment segment2 = segmentedTimeline.getSegment(segment.getSegmentStart());
                while (segment2.getSegmentStart() <= segment.getSegmentEnd()) {
                    if (!segment2.inExcludeSegments()) {
                        SegmentedTimelineTests.assertTrue((boolean)segment2.inExceptionSegments());
                    }
                    segment2.inc();
                }
            }
            segment.inc();
        }
    }

    public void testCloning() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline segmentedTimeline2 = null;
        try {
            segmentedTimeline2 = (SegmentedTimeline)segmentedTimeline.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        SegmentedTimelineTests.assertTrue((segmentedTimeline != segmentedTimeline2 ? 1 : 0) != 0);
        SegmentedTimelineTests.assertTrue((segmentedTimeline.getClass() == segmentedTimeline2.getClass() ? 1 : 0) != 0);
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.equals(segmentedTimeline2));
    }

    public void testEquals() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline segmentedTimeline2 = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.equals(segmentedTimeline2));
        segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        segmentedTimeline2 = new SegmentedTimeline(1001L, 5, 2);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.equals(segmentedTimeline2));
        segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        segmentedTimeline2 = new SegmentedTimeline(1000L, 4, 2);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.equals(segmentedTimeline2));
        segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        segmentedTimeline2 = new SegmentedTimeline(1000L, 5, 1);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.equals(segmentedTimeline2));
        segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        segmentedTimeline2 = new SegmentedTimeline(1000L, 5, 2);
        segmentedTimeline.setStartTime(1234L);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.equals(segmentedTimeline2));
        segmentedTimeline2.setStartTime(1234L);
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.equals(segmentedTimeline2));
    }

    public void testHashCode() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline segmentedTimeline2 = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.equals(segmentedTimeline2));
        int n = segmentedTimeline.hashCode();
        int n2 = segmentedTimeline2.hashCode();
        SegmentedTimelineTests.assertEquals((int)n, (int)n2);
    }

    public void testSerialization2() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline segmentedTimeline2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(segmentedTimeline);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            segmentedTimeline2 = (SegmentedTimeline)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = segmentedTimeline.equals(segmentedTimeline2);
        SegmentedTimelineTests.assertTrue((boolean)bl);
    }

    public void testBasicSegmentedTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(10L, 2, 3);
        segmentedTimeline.setStartTime(946684800000L);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684799999L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800000L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800019L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800020L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800049L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800050L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800069L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800070L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800099L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800100L));
        SegmentedTimelineTests.assertEquals((long)0L, (long)segmentedTimeline.toTimelineValue(946684800000L));
        SegmentedTimelineTests.assertEquals((long)19L, (long)segmentedTimeline.toTimelineValue(946684800019L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800020L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800049L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800050L));
        SegmentedTimelineTests.assertEquals((long)39L, (long)segmentedTimeline.toTimelineValue(946684800069L));
        SegmentedTimelineTests.assertEquals((long)40L, (long)segmentedTimeline.toTimelineValue(946684800070L));
        SegmentedTimelineTests.assertEquals((long)40L, (long)segmentedTimeline.toTimelineValue(946684800099L));
        SegmentedTimelineTests.assertEquals((long)40L, (long)segmentedTimeline.toTimelineValue(946684800100L));
        SegmentedTimelineTests.assertEquals((long)946684800000L, (long)segmentedTimeline.toMillisecond(0L));
        SegmentedTimelineTests.assertEquals((long)946684800019L, (long)segmentedTimeline.toMillisecond(19L));
        SegmentedTimelineTests.assertEquals((long)946684800050L, (long)segmentedTimeline.toMillisecond(20L));
        SegmentedTimelineTests.assertEquals((long)946684800069L, (long)segmentedTimeline.toMillisecond(39L));
        SegmentedTimelineTests.assertEquals((long)946684800100L, (long)segmentedTimeline.toMillisecond(40L));
    }

    public void testSegmentedTimelineWithException1() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(10L, 2, 3);
        segmentedTimeline.setStartTime(946684800000L);
        segmentedTimeline.addException(946684800050L);
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684799999L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800000L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800019L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800020L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800049L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800050L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800059L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800060L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800069L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800070L));
        SegmentedTimelineTests.assertFalse((boolean)segmentedTimeline.containsDomainValue(946684800099L));
        SegmentedTimelineTests.assertTrue((boolean)segmentedTimeline.containsDomainValue(946684800100L));
        SegmentedTimelineTests.assertEquals((long)0L, (long)segmentedTimeline.toTimelineValue(946684800000L));
        SegmentedTimelineTests.assertEquals((long)19L, (long)segmentedTimeline.toTimelineValue(946684800019L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800020L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800049L));
        SegmentedTimelineTests.assertEquals((long)20L, (long)segmentedTimeline.toTimelineValue(946684800050L));
        SegmentedTimelineTests.assertEquals((long)29L, (long)segmentedTimeline.toTimelineValue(946684800069L));
        SegmentedTimelineTests.assertEquals((long)30L, (long)segmentedTimeline.toTimelineValue(946684800070L));
        SegmentedTimelineTests.assertEquals((long)30L, (long)segmentedTimeline.toTimelineValue(946684800099L));
        SegmentedTimelineTests.assertEquals((long)30L, (long)segmentedTimeline.toTimelineValue(946684800100L));
        SegmentedTimelineTests.assertEquals((long)946684800000L, (long)segmentedTimeline.toMillisecond(0L));
        SegmentedTimelineTests.assertEquals((long)946684800019L, (long)segmentedTimeline.toMillisecond(19L));
        SegmentedTimelineTests.assertEquals((long)946684800060L, (long)segmentedTimeline.toMillisecond(20L));
        SegmentedTimelineTests.assertEquals((long)946684800069L, (long)segmentedTimeline.toMillisecond(29L));
        SegmentedTimelineTests.assertEquals((long)946684800100L, (long)segmentedTimeline.toMillisecond(30L));
    }

    public static void main(String[] stringArray) throws Exception {
        SegmentedTimelineTests segmentedTimelineTests = new SegmentedTimelineTests("Test");
        segmentedTimelineTests.setUp();
        segmentedTimelineTests.testMondayThoughFridayExceptionSegments();
        segmentedTimelineTests.tearDown();
    }

    static {
        MS_EXCEPTIONS = new String[]{"0", "2", "4", "10", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "47", "58", "100", "101"};
        MS2_BASE_TIMELINE_EXCEPTIONS = new String[]{"0", "8", "16", "24", "32", "40", "48", "56", "64", "72", "80", "88", "96", "104", "112", "120", "128", "136"};
        US_HOLIDAYS = new String[]{"2000-01-17", "2000-02-21", "2000-04-21", "2000-05-29", "2000-07-04", "2000-09-04", "2000-11-23", "2000-12-25", "2001-01-01", "2001-01-15", "2001-02-19", "2001-04-13", "2001-05-28", "2001-07-04", "2001-09-03", "2001-09-11", "2001-09-12", "2001-09-13", "2001-09-14", "2001-11-22", "2001-12-25", "2002-01-01", "2002-01-21", "2002-02-18", "2002-03-29", "2002-05-27", "2002-07-04", "2002-09-02", "2002-11-28", "2002-12-25"};
        FIFTEEN_MIN_EXCEPTIONS = new String[]{"2000-01-10 09:00:00", "2000-01-10 09:15:00", "2000-01-10 09:30:00", "2000-01-10 09:45:00", "2000-01-10 10:00:00", "2000-01-10 10:15:00", "2000-02-15 09:00:00", "2000-02-15 09:15:00", "2000-02-15 09:30:00", "2000-02-15 09:45:00", "2000-02-15 10:00:00", "2000-02-15 10:15:00", "2000-02-16 11:00:00", "2000-02-16 11:15:00", "2000-02-16 11:30:00", "2000-02-16 11:45:00", "2000-02-16 12:00:00", "2000-02-16 12:15:00", "2000-02-16 12:30:00", "2000-02-16 12:45:00", "2000-02-16 01:00:00", "2000-02-16 01:15:00", "2000-02-16 01:30:00", "2000-02-16 01:45:00", "2000-05-17 11:45:00", "2000-05-17 12:00:00", "2000-05-17 12:15:00", "2000-05-17 12:30:00", "2000-05-17 12:45:00", "2000-05-17 01:00:00", "2000-05-17 01:15:00", "2000-05-17 01:30:00", "2000-05-17 01:45:00", "2000-05-17 02:00:00", "2000-05-17 02:15:00", "2000-05-17 02:30:00", "2000-05-17 02:45:00", "2000-05-17 03:00:00", "2000-05-17 03:15:00", "2000-05-17 03:30:00", "2000-05-17 03:45:00", "2000-05-17 04:00:00"};
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setTimeZone(SegmentedTimeline.NO_DST_TIME_ZONE);
        DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DATE_TIME_FORMAT.setTimeZone(SegmentedTimeline.NO_DST_TIME_ZONE);
    }
}

