/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class NumberAxisTests
extends TestCase {
    private static final double EPSILON = 1.0E-7;

    public static Test suite() {
        return new TestSuite(NumberAxisTests.class);
    }

    public NumberAxisTests(String string) {
        super(string);
    }

    public void testCloning() {
        NumberAxis numberAxis = new NumberAxis("Test");
        NumberAxis numberAxis2 = null;
        try {
            numberAxis2 = (NumberAxis)numberAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        NumberAxisTests.assertTrue((numberAxis != numberAxis2 ? 1 : 0) != 0);
        NumberAxisTests.assertTrue((numberAxis.getClass() == numberAxis2.getClass() ? 1 : 0) != 0);
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
    }

    public void testEquals() {
        NumberAxis numberAxis = new NumberAxis("Test");
        NumberAxis numberAxis2 = new NumberAxis("Test");
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setAutoRangeStickyZero(false);
        NumberAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setAutoRangeStickyZero(false);
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setTickUnit(new NumberTickUnit(25.0));
        NumberAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setTickUnit(new NumberTickUnit(25.0));
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        numberAxis.setNumberFormatOverride(new DecimalFormat("0.00"));
        NumberAxisTests.assertFalse((boolean)numberAxis.equals(numberAxis2));
        numberAxis2.setNumberFormatOverride(new DecimalFormat("0.00"));
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
    }

    public void testHashCode() {
        NumberAxis numberAxis = new NumberAxis("Test");
        NumberAxis numberAxis2 = new NumberAxis("Test");
        NumberAxisTests.assertTrue((boolean)numberAxis.equals(numberAxis2));
        int n = numberAxis.hashCode();
        int n2 = numberAxis2.hashCode();
        NumberAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testTranslateJava2DToValue() {
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setRange(50.0, 100.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(10.0, 50.0, 400.0, 300.0);
        double d = numberAxis.java2DToValue(75.0, double_, RectangleEdge.LEFT);
        NumberAxisTests.assertEquals((double)d, (double)95.8333333, (double)1.0E-7);
        double d2 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.RIGHT);
        NumberAxisTests.assertEquals((double)d2, (double)95.8333333, (double)1.0E-7);
        double d3 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.TOP);
        NumberAxisTests.assertEquals((double)d3, (double)58.125, (double)1.0E-7);
        double d4 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.BOTTOM);
        NumberAxisTests.assertEquals((double)d4, (double)58.125, (double)1.0E-7);
        numberAxis.setInverted(true);
        double d5 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.LEFT);
        NumberAxisTests.assertEquals((double)d5, (double)54.1666667, (double)1.0E-7);
        double d6 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.RIGHT);
        NumberAxisTests.assertEquals((double)d6, (double)54.1666667, (double)1.0E-7);
        double d7 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.TOP);
        NumberAxisTests.assertEquals((double)d7, (double)91.875, (double)1.0E-7);
        double d8 = numberAxis.java2DToValue(75.0, double_, RectangleEdge.BOTTOM);
        NumberAxisTests.assertEquals((double)d8, (double)91.875, (double)1.0E-7);
    }

    public void testSerialization() {
        NumberAxis numberAxis = new NumberAxis("Test Axis");
        NumberAxis numberAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(numberAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            numberAxis2 = (NumberAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        NumberAxisTests.assertEquals((Object)numberAxis, numberAxis2);
    }

    public void testAutoRange1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart jFreeChart = ChartFactory.createBarChart("Test", "Categories", "Value", defaultCategoryDataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        NumberAxisTests.assertEquals((double)numberAxis.getLowerBound(), (double)0.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)numberAxis.getUpperBound(), (double)210.0, (double)1.0E-7);
    }

    public void testAutoRange2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart jFreeChart = ChartFactory.createBarChart("Test", "Categories", "Value", defaultCategoryDataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)numberAxis.getLowerBound(), (double)95.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)numberAxis.getUpperBound(), (double)205.0, (double)1.0E-7);
    }

    public void testAutoRange3() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart jFreeChart = ChartFactory.createBarChart("Test", "Categories", "Value", defaultCategoryDataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)numberAxis.getLowerBound(), (double)95.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)numberAxis.getUpperBound(), (double)205.0, (double)1.0E-7);
        DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
        defaultCategoryDataset2.setValue(900.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset2.setValue(1000.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        categoryPlot.setDataset(defaultCategoryDataset2);
        NumberAxisTests.assertEquals((double)numberAxis.getLowerBound(), (double)895.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)numberAxis.getUpperBound(), (double)1005.0, (double)1.0E-7);
    }

    public void testXYAutoRange1() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("Test", "X", "Y", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)0.9, (double)numberAxis.getLowerBound(), (double)1.0E-7);
        NumberAxisTests.assertEquals((double)3.1, (double)numberAxis.getUpperBound(), (double)1.0E-7);
    }

    public void testXYAutoRange2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("Test", "X", "Y", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)0.9, (double)numberAxis.getLowerBound(), (double)1.0E-7);
        NumberAxisTests.assertEquals((double)3.1, (double)numberAxis.getUpperBound(), (double)1.0E-7);
    }
}

