/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.MonthDateFormat;

public class MonthDateFormatTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MonthDateFormatTests.class);
    }

    public MonthDateFormatTests(String string) {
        super(string);
    }

    public void testEquals() {
        MonthDateFormat monthDateFormat = new MonthDateFormat();
        MonthDateFormat monthDateFormat2 = new MonthDateFormat();
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat2.equals(monthDateFormat));
        boolean[] blArray = new boolean[12];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[12];
        blArray[1] = true;
        monthDateFormat = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.US, 1, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.US, 1, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 1, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 1, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray2, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray2, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray2, new SimpleDateFormat("yyyy"));
        MonthDateFormatTests.assertFalse((boolean)monthDateFormat.equals(monthDateFormat2));
        monthDateFormat2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, blArray2, new SimpleDateFormat("yyyy"));
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
    }

    public void testHashCode() {
        MonthDateFormat monthDateFormat = new MonthDateFormat();
        MonthDateFormat monthDateFormat2 = new MonthDateFormat();
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
        int n = monthDateFormat.hashCode();
        int n2 = monthDateFormat2.hashCode();
        MonthDateFormatTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        MonthDateFormat monthDateFormat = new MonthDateFormat();
        MonthDateFormat monthDateFormat2 = null;
        monthDateFormat2 = (MonthDateFormat)monthDateFormat.clone();
        MonthDateFormatTests.assertTrue((monthDateFormat != monthDateFormat2 ? 1 : 0) != 0);
        MonthDateFormatTests.assertTrue((monthDateFormat.getClass() == monthDateFormat2.getClass() ? 1 : 0) != 0);
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
    }

    public void testSerialization() {
        MonthDateFormat monthDateFormat = new MonthDateFormat();
        MonthDateFormat monthDateFormat2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(monthDateFormat);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            monthDateFormat2 = (MonthDateFormat)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            MonthDateFormatTests.fail((String)exception.toString());
        }
        MonthDateFormatTests.assertTrue((boolean)monthDateFormat.equals(monthDateFormat2));
    }
}

