/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.DateTick;
import org.jfree.ui.TextAnchor;

public class DateTickTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DateTickTests.class);
    }

    public DateTickTests(String string) {
        super(string);
    }

    public void testEquals() {
        Date date = new Date(0L);
        Date date2 = new Date(1L);
        String string = "Label 1";
        String string2 = "Label 2";
        TextAnchor textAnchor = TextAnchor.CENTER;
        TextAnchor textAnchor2 = TextAnchor.BASELINE_LEFT;
        DateTick dateTick = new DateTick(date, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTick dateTick2 = new DateTick(date, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        dateTick = new DateTick(date2, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertFalse((boolean)dateTick.equals(dateTick2));
        dateTick2 = new DateTick(date2, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        dateTick = new DateTick(date, string2, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertFalse((boolean)dateTick.equals(dateTick2));
        dateTick2 = new DateTick(date, string2, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        dateTick = new DateTick(date, string, textAnchor2, textAnchor, 1.5707963267948966);
        DateTickTests.assertFalse((boolean)dateTick.equals(dateTick2));
        dateTick2 = new DateTick(date, string, textAnchor2, textAnchor, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        dateTick = new DateTick(date, string, textAnchor, textAnchor2, 1.5707963267948966);
        DateTickTests.assertFalse((boolean)dateTick.equals(dateTick2));
        dateTick2 = new DateTick(date, string, textAnchor, textAnchor2, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        dateTick = new DateTick(date, string, textAnchor, textAnchor, 1.0471975511965976);
        DateTickTests.assertFalse((boolean)dateTick.equals(dateTick2));
        dateTick2 = new DateTick(date, string, textAnchor, textAnchor, 1.0471975511965976);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
    }

    public void testHashCode() {
        Date date = new Date(0L);
        String string = "Label 1";
        TextAnchor textAnchor = TextAnchor.CENTER;
        DateTick dateTick = new DateTick(date, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTick dateTick2 = new DateTick(date, string, textAnchor, textAnchor, 1.5707963267948966);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
        int n = dateTick.hashCode();
        int n2 = dateTick2.hashCode();
        DateTickTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        DateTick dateTick = new DateTick(new Date(0L), "Label", TextAnchor.CENTER, TextAnchor.CENTER, 10.0);
        DateTick dateTick2 = null;
        try {
            dateTick2 = (DateTick)dateTick.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DateTickTests.assertTrue((dateTick != dateTick2 ? 1 : 0) != 0);
        DateTickTests.assertTrue((dateTick.getClass() == dateTick2.getClass() ? 1 : 0) != 0);
        DateTickTests.assertTrue((boolean)dateTick.equals(dateTick2));
    }

    public void testSerialization() {
        DateTick dateTick = new DateTick(new Date(0L), "Label", TextAnchor.CENTER, TextAnchor.CENTER, 10.0);
        DateTick dateTick2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(dateTick);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            dateTick2 = (DateTick)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DateTickTests.assertEquals((Object)dateTick, dateTick2);
    }
}

