/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CyclicNumberAxis;

public class CyclicNumberAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CyclicNumberAxisTests.class);
    }

    public CyclicNumberAxisTests(String string) {
        super(string);
    }

    public void testCloning() {
        CyclicNumberAxis cyclicNumberAxis = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis cyclicNumberAxis2 = null;
        try {
            cyclicNumberAxis2 = (CyclicNumberAxis)cyclicNumberAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CyclicNumberAxisTests.assertTrue((cyclicNumberAxis != cyclicNumberAxis2 ? 1 : 0) != 0);
        CyclicNumberAxisTests.assertTrue((cyclicNumberAxis.getClass() == cyclicNumberAxis2.getClass() ? 1 : 0) != 0);
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
    }

    public void testEquals() {
        CyclicNumberAxis cyclicNumberAxis = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis cyclicNumberAxis2 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis.setPeriod(5.0);
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setPeriod(5.0);
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis.setOffset(2.0);
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setOffset(2.0);
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis.setAdvanceLinePaint(Color.cyan);
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setAdvanceLinePaint(Color.cyan);
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        BasicStroke basicStroke = new BasicStroke(0.2f);
        cyclicNumberAxis.setAdvanceLineStroke(basicStroke);
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setAdvanceLineStroke(basicStroke);
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis.setAdvanceLineVisible(!cyclicNumberAxis.isAdvanceLineVisible());
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setAdvanceLineVisible(cyclicNumberAxis.isAdvanceLineVisible());
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis.setBoundMappedToLastCycle(!cyclicNumberAxis.isBoundMappedToLastCycle());
        CyclicNumberAxisTests.assertFalse((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        cyclicNumberAxis2.setBoundMappedToLastCycle(cyclicNumberAxis.isBoundMappedToLastCycle());
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
    }

    public void testHashCode() {
        CyclicNumberAxis cyclicNumberAxis = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis cyclicNumberAxis2 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxisTests.assertTrue((boolean)cyclicNumberAxis.equals(cyclicNumberAxis2));
        int n = cyclicNumberAxis.hashCode();
        int n2 = cyclicNumberAxis2.hashCode();
        CyclicNumberAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testSerialization() {
        CyclicNumberAxis cyclicNumberAxis = new CyclicNumberAxis(10.0, 0.0, "Test Axis");
        CyclicNumberAxis cyclicNumberAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(cyclicNumberAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            cyclicNumberAxis2 = (CyclicNumberAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CyclicNumberAxisTests.assertEquals((Object)cyclicNumberAxis, cyclicNumberAxis2);
    }
}

