/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.TextAnchor;

public class CategoryTickTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryTickTests.class);
    }

    public CategoryTickTests(String string) {
        super(string);
    }

    public void testEquals() {
        String string = "C1";
        String string2 = "C2";
        TextBlock textBlock = new TextBlock();
        textBlock.addLine(new TextLine("Block 1"));
        TextBlock textBlock2 = new TextBlock();
        textBlock.addLine(new TextLine("Block 2"));
        TextBlockAnchor textBlockAnchor = TextBlockAnchor.CENTER;
        TextBlockAnchor textBlockAnchor2 = TextBlockAnchor.BOTTOM_CENTER;
        TextAnchor textAnchor = TextAnchor.CENTER;
        TextAnchor textAnchor2 = TextAnchor.BASELINE_LEFT;
        CategoryTick categoryTick = new CategoryTick((Comparable)((Object)string), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTick categoryTick2 = new CategoryTick((Comparable)((Object)string), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        categoryTick = new CategoryTick((Comparable)((Object)string2), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertFalse((boolean)categoryTick.equals(categoryTick2));
        categoryTick2 = new CategoryTick((Comparable)((Object)string2), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        categoryTick = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertFalse((boolean)categoryTick.equals(categoryTick2));
        categoryTick2 = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        categoryTick = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor, 1.0);
        CategoryTickTests.assertFalse((boolean)categoryTick.equals(categoryTick2));
        categoryTick2 = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        categoryTick = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor2, 1.0);
        CategoryTickTests.assertFalse((boolean)categoryTick.equals(categoryTick2));
        categoryTick2 = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor2, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        categoryTick = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor2, 2.0);
        CategoryTickTests.assertFalse((boolean)categoryTick.equals(categoryTick2));
        categoryTick2 = new CategoryTick((Comparable)((Object)string2), textBlock2, textBlockAnchor2, textAnchor2, 2.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
    }

    public void testHashCode() {
        String string = "C1";
        TextBlock textBlock = new TextBlock();
        textBlock.addLine(new TextLine("Block 1"));
        textBlock.addLine(new TextLine("Block 2"));
        TextBlockAnchor textBlockAnchor = TextBlockAnchor.CENTER;
        TextAnchor textAnchor = TextAnchor.CENTER;
        CategoryTick categoryTick = new CategoryTick((Comparable)((Object)string), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTick categoryTick2 = new CategoryTick((Comparable)((Object)string), textBlock, textBlockAnchor, textAnchor, 1.0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
        int n = categoryTick.hashCode();
        int n2 = categoryTick2.hashCode();
        CategoryTickTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        CategoryTick categoryTick = new CategoryTick((Comparable)((Object)"C1"), new TextBlock(), TextBlockAnchor.CENTER, TextAnchor.CENTER, 1.5);
        CategoryTick categoryTick2 = null;
        try {
            categoryTick2 = (CategoryTick)categoryTick.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CategoryTickTests.assertTrue((categoryTick != categoryTick2 ? 1 : 0) != 0);
        CategoryTickTests.assertTrue((categoryTick.getClass() == categoryTick2.getClass() ? 1 : 0) != 0);
        CategoryTickTests.assertTrue((boolean)categoryTick.equals(categoryTick2));
    }

    public void testSerialization() {
        CategoryTick categoryTick = new CategoryTick((Comparable)((Object)"C1"), new TextBlock(), TextBlockAnchor.CENTER, TextAnchor.CENTER, 1.5);
        CategoryTick categoryTick2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryTick);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryTick2 = (CategoryTick)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CategoryTickTests.assertEquals((Object)categoryTick, categoryTick2);
    }
}

