/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;

public class CategoryAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryAxisTests.class);
    }

    public CategoryAxisTests(String string) {
        super(string);
    }

    public void testEquals() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        CategoryAxis categoryAxis2 = new CategoryAxis("Test");
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setLowerMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setLowerMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setUpperMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setUpperMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setCategoryMargin(0.15);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setCategoryMargin(0.15);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setMaximumCategoryLabelWidthRatio(0.98f);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setMaximumCategoryLabelWidthRatio(0.98f);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setCategoryLabelPositionOffset(11);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setCategoryLabelPositionOffset(11);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        CategoryAxisTests.assertFalse((boolean)categoryAxis.equals(categoryAxis2));
        categoryAxis2.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
    }

    public void testHashCode() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        CategoryAxis categoryAxis2 = new CategoryAxis("Test");
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
        int n = categoryAxis.hashCode();
        int n2 = categoryAxis2.hashCode();
        CategoryAxisTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        CategoryAxis categoryAxis2 = null;
        try {
            categoryAxis2 = (CategoryAxis)categoryAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CategoryAxisTests.assertTrue((categoryAxis != categoryAxis2 ? 1 : 0) != 0);
        CategoryAxisTests.assertTrue((categoryAxis.getClass() == categoryAxis2.getClass() ? 1 : 0) != 0);
        CategoryAxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
    }

    public void testSerialization() {
        CategoryAxis categoryAxis = new CategoryAxis("Test Axis");
        CategoryAxis categoryAxis2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryAxis);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryAxis2 = (CategoryAxis)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CategoryAxisTests.assertEquals((Object)categoryAxis, categoryAxis2);
    }
}

