/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.ui.RectangleInsets;

public class AxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(AxisTests.class);
    }

    public AxisTests(String string) {
        super(string);
    }

    public void testCloning() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        categoryAxis.setAxisLinePaint(Color.red);
        CategoryAxis categoryAxis2 = null;
        try {
            categoryAxis2 = (CategoryAxis)categoryAxis.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        AxisTests.assertTrue((categoryAxis != categoryAxis2 ? 1 : 0) != 0);
        AxisTests.assertTrue((categoryAxis.getClass() == categoryAxis2.getClass() ? 1 : 0) != 0);
        AxisTests.assertTrue((boolean)categoryAxis.equals(categoryAxis2));
    }

    public void testEquals() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        CategoryAxis categoryAxis2 = new CategoryAxis("Test");
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setVisible(false);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setVisible(false);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setLabel("New Label");
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setLabel("New Label");
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setLabelFont(new Font("Dialog", 0, 8));
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setLabelFont(new Font("Dialog", 0, 8));
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setLabelPaint(Color.blue);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setLabelPaint(Color.blue);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setLabelAngle(1.23);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setLabelAngle(1.23);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setAxisLineVisible(false);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setAxisLineVisible(false);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        BasicStroke basicStroke = new BasicStroke(1.1f);
        categoryAxis.setAxisLineStroke(basicStroke);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setAxisLineStroke(basicStroke);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setAxisLinePaint(Color.blue);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setAxisLinePaint(Color.blue);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickLabelsVisible(false);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickLabelsVisible(false);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickLabelFont(new Font("Dialog", 0, 12));
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickLabelFont(new Font("Dialog", 0, 12));
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickLabelPaint(Color.red);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickLabelPaint(Color.red);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickMarksVisible(true);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickMarksVisible(true);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickMarkInsideLength(1.23f);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickMarkInsideLength(1.23f);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickMarkOutsideLength(1.23f);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickMarkOutsideLength(1.23f);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickMarkStroke(new BasicStroke(2.0f));
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickMarkStroke(new BasicStroke(2.0f));
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setTickMarkPaint(Color.green);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setTickMarkPaint(Color.green);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis.setFixedDimension(3.21f);
        AxisTests.assertFalse((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        categoryAxis2.setFixedDimension(3.21f);
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
    }

    public void testHashCode() {
        CategoryAxis categoryAxis = new CategoryAxis("Test");
        CategoryAxis categoryAxis2 = new CategoryAxis("Test");
        AxisTests.assertTrue((boolean)((Axis)categoryAxis).equals(categoryAxis2));
        int n = ((Object)categoryAxis).hashCode();
        int n2 = ((Object)categoryAxis2).hashCode();
        AxisTests.assertEquals((int)n, (int)n2);
    }
}

