/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.ui.TextAnchor;

public class XYTextAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYTextAnnotationTests.class);
    }

    public XYTextAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation xYTextAnnotation2 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation = new XYTextAnnotation("ABC", 10.0, 20.0);
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2 = new XYTextAnnotation("ABC", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation.setFont(new Font("Serif", 0, 23));
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2.setFont(new Font("Serif", 0, 23));
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        GradientPaint gradientPaint = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow);
        GradientPaint gradientPaint2 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow);
        xYTextAnnotation.setPaint(gradientPaint);
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2.setPaint(gradientPaint2);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation.setRotationAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2.setRotationAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation.setRotationAngle(12.3);
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2.setRotationAngle(12.3);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation.setTextAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertFalse((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        xYTextAnnotation2.setTextAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
    }

    public void testHashCode() {
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation xYTextAnnotation2 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
        int n = xYTextAnnotation.hashCode();
        int n2 = xYTextAnnotation2.hashCode();
        XYTextAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation xYTextAnnotation2 = null;
        try {
            xYTextAnnotation2 = (XYTextAnnotation)xYTextAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYTextAnnotationTests.assertTrue((xYTextAnnotation != xYTextAnnotation2 ? 1 : 0) != 0);
        XYTextAnnotationTests.assertTrue((xYTextAnnotation.getClass() == xYTextAnnotation2.getClass() ? 1 : 0) != 0);
        XYTextAnnotationTests.assertTrue((boolean)xYTextAnnotation.equals(xYTextAnnotation2));
    }

    public void testSerialization() {
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation xYTextAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYTextAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYTextAnnotation2 = (XYTextAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYTextAnnotationTests.assertEquals((Object)xYTextAnnotation, xYTextAnnotation2);
    }
}

