/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYPointerAnnotation;

public class XYPointerAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYPointerAnnotationTests.class);
    }

    public XYPointerAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYPointerAnnotation xYPointerAnnotation = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation xYPointerAnnotation2 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setAngle(0.7853981633974483);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setAngle(0.7853981633974483);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setTipRadius(20.0);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setTipRadius(20.0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setBaseRadius(5.0);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setBaseRadius(5.0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setArrowLength(33.0);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setArrowLength(33.0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setArrowWidth(9.0);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setArrowWidth(9.0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        BasicStroke basicStroke = new BasicStroke(1.5f);
        xYPointerAnnotation.setArrowStroke(basicStroke);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setArrowStroke(basicStroke);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setArrowPaint(Color.blue);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setArrowPaint(Color.blue);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation.setLabelOffset(10.0);
        XYPointerAnnotationTests.assertFalse((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        xYPointerAnnotation2.setLabelOffset(10.0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
    }

    public void testHashCode() {
        XYPointerAnnotation xYPointerAnnotation = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation xYPointerAnnotation2 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
        int n = xYPointerAnnotation.hashCode();
        int n2 = xYPointerAnnotation2.hashCode();
        XYPointerAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYPointerAnnotation xYPointerAnnotation = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation xYPointerAnnotation2 = null;
        try {
            xYPointerAnnotation2 = (XYPointerAnnotation)xYPointerAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYPointerAnnotationTests.assertTrue((xYPointerAnnotation != xYPointerAnnotation2 ? 1 : 0) != 0);
        XYPointerAnnotationTests.assertTrue((xYPointerAnnotation.getClass() == xYPointerAnnotation2.getClass() ? 1 : 0) != 0);
        XYPointerAnnotationTests.assertTrue((boolean)xYPointerAnnotation.equals(xYPointerAnnotation2));
    }

    public void testSerialization() {
        XYPointerAnnotation xYPointerAnnotation = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation xYPointerAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYPointerAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYPointerAnnotation2 = (XYPointerAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYPointerAnnotationTests.assertEquals((Object)xYPointerAnnotation, xYPointerAnnotation2);
    }
}

