/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYLineAnnotation;

public class XYLineAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYLineAnnotationTests.class);
    }

    public XYLineAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        BasicStroke basicStroke = new BasicStroke(2.0f);
        XYLineAnnotation xYLineAnnotation = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotation xYLineAnnotation2 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotationTests.assertTrue((boolean)xYLineAnnotation.equals(xYLineAnnotation2));
    }

    public void testHashCode() {
        BasicStroke basicStroke = new BasicStroke(2.0f);
        XYLineAnnotation xYLineAnnotation = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotation xYLineAnnotation2 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotationTests.assertTrue((boolean)xYLineAnnotation.equals(xYLineAnnotation2));
        int n = xYLineAnnotation.hashCode();
        int n2 = xYLineAnnotation2.hashCode();
        XYLineAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        BasicStroke basicStroke = new BasicStroke(2.0f);
        XYLineAnnotation xYLineAnnotation = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotation xYLineAnnotation2 = null;
        try {
            xYLineAnnotation2 = (XYLineAnnotation)xYLineAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYLineAnnotationTests.assertTrue((xYLineAnnotation != xYLineAnnotation2 ? 1 : 0) != 0);
        XYLineAnnotationTests.assertTrue((xYLineAnnotation.getClass() == xYLineAnnotation2.getClass() ? 1 : 0) != 0);
        XYLineAnnotationTests.assertTrue((boolean)xYLineAnnotation.equals(xYLineAnnotation2));
    }

    public void testSerialization() {
        BasicStroke basicStroke = new BasicStroke(2.0f);
        XYLineAnnotation xYLineAnnotation = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, basicStroke, Color.blue);
        XYLineAnnotation xYLineAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYLineAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYLineAnnotation2 = (XYLineAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYLineAnnotationTests.assertEquals((Object)xYLineAnnotation, xYLineAnnotation2);
    }
}

