/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.ui.Drawable;

public class XYDrawableAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDrawableAnnotationTests.class);
    }

    public XYDrawableAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYDrawableAnnotation xYDrawableAnnotation = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation xYDrawableAnnotation2 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotationTests.assertTrue((boolean)xYDrawableAnnotation.equals(xYDrawableAnnotation2));
    }

    public void testHashCode() {
        XYDrawableAnnotation xYDrawableAnnotation = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation xYDrawableAnnotation2 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotationTests.assertTrue((boolean)xYDrawableAnnotation.equals(xYDrawableAnnotation2));
        int n = xYDrawableAnnotation.hashCode();
        int n2 = xYDrawableAnnotation2.hashCode();
        XYDrawableAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYDrawableAnnotation xYDrawableAnnotation = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation xYDrawableAnnotation2 = null;
        try {
            xYDrawableAnnotation2 = (XYDrawableAnnotation)xYDrawableAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYDrawableAnnotationTests.assertTrue((xYDrawableAnnotation != xYDrawableAnnotation2 ? 1 : 0) != 0);
        XYDrawableAnnotationTests.assertTrue((xYDrawableAnnotation.getClass() == xYDrawableAnnotation2.getClass() ? 1 : 0) != 0);
        XYDrawableAnnotationTests.assertTrue((boolean)xYDrawableAnnotation.equals(xYDrawableAnnotation2));
    }

    public void testSerialization() {
        XYDrawableAnnotation xYDrawableAnnotation = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation xYDrawableAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYDrawableAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYDrawableAnnotation2 = (XYDrawableAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYDrawableAnnotationTests.assertEquals((Object)xYDrawableAnnotation, xYDrawableAnnotation2);
    }

    static class TestDrawable
    implements Drawable,
    Cloneable,
    Serializable {
        public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof TestDrawable;
        }
    }
}

