/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYBoxAnnotation;

public class XYBoxAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYBoxAnnotationTests.class);
    }

    public XYBoxAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYBoxAnnotation xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation xYBoxAnnotation2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation2.equals(xYBoxAnnotation));
        xYBoxAnnotation = new XYBoxAnnotation(2.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation2 = new XYBoxAnnotation(2.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.yellow);
        XYBoxAnnotationTests.assertFalse((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        xYBoxAnnotation2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.yellow);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
    }

    public void testHashCode() {
        XYBoxAnnotation xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation xYBoxAnnotation2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
        int n = xYBoxAnnotation.hashCode();
        int n2 = xYBoxAnnotation2.hashCode();
        XYBoxAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYBoxAnnotation xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation xYBoxAnnotation2 = null;
        try {
            xYBoxAnnotation2 = (XYBoxAnnotation)xYBoxAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYBoxAnnotationTests.assertTrue((xYBoxAnnotation != xYBoxAnnotation2 ? 1 : 0) != 0);
        XYBoxAnnotationTests.assertTrue((xYBoxAnnotation.getClass() == xYBoxAnnotation2.getClass() ? 1 : 0) != 0);
        XYBoxAnnotationTests.assertTrue((boolean)xYBoxAnnotation.equals(xYBoxAnnotation2));
    }

    public void testSerialization() {
        XYBoxAnnotation xYBoxAnnotation = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation xYBoxAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYBoxAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYBoxAnnotation2 = (XYBoxAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYBoxAnnotationTests.assertEquals((Object)xYBoxAnnotation, xYBoxAnnotation2);
    }
}

