/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;

public class CategoryTextAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryTextAnnotationTests.class);
    }

    public CategoryTextAnnotationTests(String string) {
        super(string);
    }

    public void testEquals() {
        CategoryTextAnnotation categoryTextAnnotation = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation categoryTextAnnotation2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation.setCategory((Comparable)((Object)"Category 2"));
        CategoryTextAnnotationTests.assertFalse((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation2.setCategory((Comparable)((Object)"Category 2"));
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation.setCategoryAnchor(CategoryAnchor.START);
        CategoryTextAnnotationTests.assertFalse((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation2.setCategoryAnchor(CategoryAnchor.START);
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation.setValue(0.15);
        CategoryTextAnnotationTests.assertFalse((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        categoryTextAnnotation2.setValue(0.15);
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
    }

    public void testHashcode() {
        CategoryTextAnnotation categoryTextAnnotation = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation categoryTextAnnotation2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
        int n = categoryTextAnnotation.hashCode();
        int n2 = categoryTextAnnotation2.hashCode();
        CategoryTextAnnotationTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        CategoryTextAnnotation categoryTextAnnotation = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation categoryTextAnnotation2 = null;
        try {
            categoryTextAnnotation2 = (CategoryTextAnnotation)categoryTextAnnotation.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CategoryTextAnnotationTests.assertTrue((categoryTextAnnotation != categoryTextAnnotation2 ? 1 : 0) != 0);
        CategoryTextAnnotationTests.assertTrue((categoryTextAnnotation.getClass() == categoryTextAnnotation2.getClass() ? 1 : 0) != 0);
        CategoryTextAnnotationTests.assertTrue((boolean)categoryTextAnnotation.equals(categoryTextAnnotation2));
    }

    public void testSerialization() {
        CategoryTextAnnotation categoryTextAnnotation = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation categoryTextAnnotation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryTextAnnotation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryTextAnnotation2 = (CategoryTextAnnotation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CategoryTextAnnotationTests.assertEquals((Object)categoryTextAnnotation, categoryTextAnnotation2);
    }
}

