/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYDrawableAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6540812859722691020L;
    private double x;
    private double y;
    private double width;
    private double height;
    private Drawable drawable;

    public XYDrawableAnnotation(double d, double d2, double d3, double d4, Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Null 'drawable' argument.");
        }
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.drawable = drawable;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)f - this.width / 2.0, (double)f2 - this.height / 2.0, this.width, this.height);
        this.drawable.draw(graphics2D, double_);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, double_, n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYDrawableAnnotation)) {
            return false;
        }
        XYDrawableAnnotation xYDrawableAnnotation = (XYDrawableAnnotation)object;
        if (this.x != xYDrawableAnnotation.x) {
            return false;
        }
        if (this.y != xYDrawableAnnotation.y) {
            return false;
        }
        if (this.width != xYDrawableAnnotation.width) {
            return false;
        }
        if (this.height != xYDrawableAnnotation.height) {
            return false;
        }
        return ObjectUtilities.equal(this.drawable, xYDrawableAnnotation.drawable);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.width);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.height);
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

