/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.ShapeUtilities;

public class LegendItem
implements Serializable {
    private static final long serialVersionUID = -797214582948827144L;
    private String label;
    private String description;
    private String toolTipText;
    private String urlText;
    private boolean shapeVisible;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient Stroke lineStroke;
    private transient Paint linePaint;
    private static final Shape UNUSED_SHAPE = new Line2D.Float();
    private static final Stroke UNUSED_STROKE = new BasicStroke(0.0f);

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Paint paint) {
        this(string, string2, string3, string4, true, shape, true, paint, false, Color.black, UNUSED_STROKE, false, UNUSED_SHAPE, UNUSED_STROKE, Color.black);
    }

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Paint paint, Stroke stroke, Paint paint2) {
        this(string, string2, string3, string4, true, shape, true, paint, true, paint2, stroke, false, UNUSED_SHAPE, UNUSED_STROKE, Color.black);
    }

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Stroke stroke, Paint paint) {
        this(string, string2, string3, string4, false, UNUSED_SHAPE, false, Color.black, false, Color.black, UNUSED_STROKE, true, shape, stroke, paint);
    }

    public LegendItem(String string, String string2, String string3, String string4, boolean bl, Shape shape, boolean bl2, Paint paint, boolean bl3, Paint paint2, Stroke stroke, boolean bl4, Shape shape2, Stroke stroke2, Paint paint3) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        if (stroke2 == null) {
            throw new IllegalArgumentException("Null 'lineStroke' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'outlinePaint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'outlineStroke' argument.");
        }
        this.label = string;
        this.description = string2;
        this.shapeVisible = bl;
        this.shape = shape;
        this.shapeFilled = bl2;
        this.fillPaint = paint;
        this.shapeOutlineVisible = bl3;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke;
        this.lineVisible = bl4;
        this.line = shape2;
        this.lineStroke = stroke2;
        this.linePaint = paint3;
        this.toolTipText = string3;
        this.urlText = string4;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getURLText() {
        return this.urlText;
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public Shape getLine() {
        return this.line;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LegendItem)) {
            return false;
        }
        LegendItem legendItem = (LegendItem)object;
        if (!this.label.equals(legendItem.label)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.description, legendItem.description)) {
            return false;
        }
        if (this.shapeVisible != legendItem.shapeVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, legendItem.shape)) {
            return false;
        }
        if (this.shapeFilled != legendItem.shapeFilled) {
            return false;
        }
        if (!this.fillPaint.equals(legendItem.fillPaint)) {
            return false;
        }
        if (this.shapeOutlineVisible != legendItem.shapeOutlineVisible) {
            return false;
        }
        if (!this.outlineStroke.equals(legendItem.outlineStroke)) {
            return false;
        }
        if (!this.outlinePaint.equals(legendItem.outlinePaint)) {
            return false;
        }
        if (!this.lineVisible == legendItem.lineVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.line, legendItem.line)) {
            return false;
        }
        if (!this.lineStroke.equals(legendItem.lineStroke)) {
            return false;
        }
        return this.linePaint.equals(legendItem.linePaint);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeShape(this.line, objectOutputStream);
        SerialUtilities.writeStroke(this.lineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.linePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.line = SerialUtilities.readShape(objectInputStream);
        this.lineStroke = SerialUtilities.readStroke(objectInputStream);
        this.linePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

