/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PasswordReader {
    private static final String ECHO_PROPERTY = "pulse.echo.passwords";
    private BufferedReader reader;
    private Object console;
    private Method readPasswordMethod;

    public PasswordReader(BufferedReader reader) {
        this.reader = reader;
        try {
            Method getConsoleMethod = System.class.getMethod("console", new Class[0]);
            this.console = getConsoleMethod.invoke(null, new Object[0]);
            Class<?> consoleClass = Class.forName("java.io.Console");
            this.readPasswordMethod = consoleClass.getMethod("readPassword", String.class, Object[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readPassword(String prompt) {
        if (this.echo()) {
            System.out.print(prompt);
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (this.readPasswordMethod == null) {
            return this.maskedPassword(prompt);
        }
        try {
            char[] password = (char[])this.readPasswordMethod.invoke(this.console, prompt, new Object[0]);
            return new String(password);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private boolean echo() {
        String property = System.getProperty(ECHO_PROPERTY);
        return property != null && Boolean.valueOf(property) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String maskedPassword(String prompt) {
        EraserThread eraserThread = new EraserThread(prompt);
        try {
            Thread t = new Thread(eraserThread);
            t.start();
            String string = this.reader.readLine();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            eraserThread.stopMasking();
        }
    }

    private class EraserThread
    implements Runnable {
        private boolean run;

        public EraserThread(String prompt) {
            System.out.print(prompt);
        }

        public void run() {
            this.run = true;
            while (this.run) {
                System.out.print("\b ");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopMasking() {
            this.run = false;
        }
    }
}

