/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.config.CompositeConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.config.FileConfig;
import com.zutubi.pulse.config.PropertiesConfig;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;

public class PersonalBuildConfig
implements Config {
    private static final String PROPERTIES_FILENAME = ".pulse.properties";
    public static final String PROPERTY_PULSE_URL = "pulse.url";
    public static final String PROPERTY_PULSE_USER = "pulse.user";
    public static final String PROPERTY_PULSE_PASSWORD = "pulse.password";
    public static final String PROPERTY_PROJECT = "project";
    public static final String PROPERTY_SPECIFICATION = "specification";
    public static final String PROPERTY_CHECK_REPOSITORY = "check.repository";
    public static final String PROPERTY_CONFIRM_UPDATE = "confirm.update";
    public static final String PROPERTY_CONFIRMED_VERSION = "confirmed.version";
    private File base;
    private ConfigSupport config;
    private ConfigSupport localConfig;
    private ConfigSupport userConfig;

    public PersonalBuildConfig(File base, Config ui) {
        this.base = base;
        CompositeConfig composite = new CompositeConfig(new Config[]{ui});
        composite.append((Config)new PropertiesConfig(System.getProperties()));
        this.localConfig = new ConfigSupport((Config)new FileConfig(this.getLocalConfigFile()));
        composite.append((Config)this.localConfig);
        for (base = base.getParentFile(); base != null; base = base.getParentFile()) {
            File properties = new File(base, PROPERTIES_FILENAME);
            if (!properties.isFile()) continue;
            composite.append((Config)new FileConfig(properties));
        }
        File userFile = this.getUserConfigFile();
        if (userFile != null) {
            this.userConfig = new ConfigSupport((Config)new FileConfig(userFile));
            composite.append((Config)this.userConfig);
        }
        composite.append(this.getDefaults());
        this.config = new ConfigSupport((Config)composite);
    }

    private Config getDefaults() {
        PropertiesConfig defaults = new PropertiesConfig();
        String userName = System.getProperty("user.name");
        if (userName != null) {
            defaults.setProperty(PROPERTY_PULSE_USER, userName);
        }
        defaults.setProperty(PROPERTY_SPECIFICATION, "");
        return defaults;
    }

    public String getPulseUrl() {
        String url = this.config.getProperty(PROPERTY_PULSE_URL);
        if (url != null && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getPulseUser() {
        return this.config.getProperty(PROPERTY_PULSE_USER);
    }

    public String getPulsePassword() {
        return this.config.getProperty(PROPERTY_PULSE_PASSWORD);
    }

    public String getProject() {
        return this.config.getProperty(PROPERTY_PROJECT);
    }

    public String getSpecification() {
        return this.config.getProperty(PROPERTY_SPECIFICATION);
    }

    public File getBase() {
        return this.base;
    }

    public boolean getCheckRepository() {
        return this.config.getBooleanProperty(PROPERTY_CHECK_REPOSITORY, Boolean.valueOf(true));
    }

    public boolean setCheckRepository(boolean check) {
        return this.setBooleanProperty(PROPERTY_CHECK_REPOSITORY, check);
    }

    public boolean getConfirmUpdate() {
        return this.config.getBooleanProperty(PROPERTY_CONFIRM_UPDATE, Boolean.valueOf(true));
    }

    public boolean setConfirmUpdate(boolean confirm) {
        return this.setBooleanProperty(PROPERTY_CONFIRM_UPDATE, confirm);
    }

    public int getConfirmedVersion() {
        return this.config.getInteger(PROPERTY_CONFIRMED_VERSION, Integer.valueOf(0));
    }

    public boolean setConfirmedVersion(int version) {
        return this.setIntegerProperty(PROPERTY_CONFIRMED_VERSION, version);
    }

    private boolean setBooleanProperty(String property, boolean value) {
        if (this.userConfig == null) {
            return false;
        }
        this.userConfig.setBooleanProperty(property, Boolean.valueOf(value));
        return true;
    }

    private boolean setIntegerProperty(String property, int value) {
        if (this.userConfig == null) {
            return false;
        }
        this.userConfig.setInteger(property, Integer.valueOf(value));
        return true;
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, false);
    }

    public void setProperty(String key, String value, boolean local) {
        if (local) {
            this.localConfig.setProperty(key, value);
        } else {
            this.userConfig.setProperty(key, value);
        }
    }

    public void removeProperty(String key) {
        this.config.removeProperty(key);
    }

    public boolean hasProperty(String key) {
        return this.config.hasProperty(key);
    }

    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    public boolean isWriteable() {
        return this.config.isWriteable();
    }

    public File getUserConfigFile() {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            return FileSystemUtils.composeFile((String[])new String[]{userHome, PROPERTIES_FILENAME});
        }
        return null;
    }

    public File getLocalConfigFile() {
        return new File(this.base, PROPERTIES_FILENAME);
    }
}

