/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.config.CommandLineConfig;
import com.zutubi.pulse.config.CompositeConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.PropertiesConfig;
import com.zutubi.pulse.personal.ConsoleUI;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.personal.PersonalBuildClient;
import com.zutubi.pulse.personal.PersonalBuildConfig;
import com.zutubi.pulse.personal.PersonalBuildException;
import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.personal.UserAbortException;
import com.zutubi.pulse.scm.WorkingCopy;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonalBuildCommand
implements Command {
    private File base;
    private String[] files;
    private CommandLineConfig switchConfig;
    private PropertiesConfig defineConfig;
    private String patchFilename;
    private boolean noRequest = false;
    private boolean statusOnly = false;
    private ConsoleUI console = new ConsoleUI();

    public void processArguments(String ... argv) throws ParseException {
        this.switchConfig = new CommandLineConfig();
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"quiet");
        options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"status");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"no-request");
        options.addOption(OptionBuilder.create((char)'n'));
        this.addPropertyOption(options, 's', "server", "pulse.url");
        this.addPropertyOption(options, 'u', "user", "pulse.user");
        this.addPropertyOption(options, 'p', "password", "pulse.password");
        this.addPropertyOption(options, 'r', "project", "project");
        this.addPropertyOption(options, 'b', "specification", "specification");
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(options, argv, true);
        Properties defines = new Properties();
        if (commandLine.hasOption('d')) {
            this.addDefinedOption(defines, commandLine.getOptionValue('d'));
        }
        if (commandLine.hasOption('q')) {
            this.console.setVerbosity(PersonalBuildUI.Verbosity.QUIET);
        }
        if (commandLine.hasOption('v')) {
            this.console.setVerbosity(PersonalBuildUI.Verbosity.VERBOSE);
        }
        if (commandLine.hasOption('t')) {
            this.statusOnly = true;
        }
        if (commandLine.hasOption('n')) {
            this.noRequest = true;
        }
        if (commandLine.hasOption('f')) {
            this.patchFilename = commandLine.getOptionValue('f');
        }
        this.switchConfig.setCommandLine(commandLine);
        this.defineConfig = new PropertiesConfig(defines);
        this.base = new File(System.getProperty("user.dir"));
        this.files = commandLine.getArgs();
    }

    private void addDefinedOption(Properties defines, String value) throws ParseException {
        int index = value.indexOf(61);
        if (index <= 0 || index >= value.length() - 1) {
            throw new ParseException("Invalid property definition syntax '" + value + "' (expected name=value)");
        }
        String propertyName = value.substring(0, index);
        String propertyValue = value.substring(index + 1);
        defines.put(propertyName, propertyValue);
    }

    private void addPropertyOption(Options options, char shortOption, String longOption, String property) {
        OptionBuilder.withLongOpt((String)longOption);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)shortOption));
        this.switchConfig.mapSwitch(Character.toString(shortOption), property);
    }

    private int execute(String[] argv) throws ParseException {
        this.processArguments(argv);
        CompositeConfig uiConfig = new CompositeConfig(new Config[]{this.switchConfig, this.defineConfig});
        PersonalBuildConfig config = new PersonalBuildConfig(this.base, (Config)uiConfig);
        PersonalBuildClient client = new PersonalBuildClient(config);
        client.setUI(this.console);
        try {
            WorkingCopy wc = client.checkConfiguration();
            if (this.statusOnly) {
                WorkingCopyStatus wcs = client.getStatus(wc, this.files);
                if (!wcs.hasChanges()) {
                    this.console.status("No changes found.");
                }
            } else {
                File patchFile;
                if (this.patchFilename == null) {
                    try {
                        patchFile = File.createTempFile("pulse.patch.", ".zip");
                        patchFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        this.console.error("Unable to create temporary patch file: " + e.getMessage(), e);
                        return 1;
                    }
                } else {
                    patchFile = new File(this.patchFilename);
                }
                PatchArchive patch = client.preparePatch(wc, patchFile, this.files);
                if (patch == null) {
                    this.console.status("No changes found.");
                } else if (!this.noRequest) {
                    client.sendRequest(patch);
                }
            }
        }
        catch (UserAbortException e) {
            return 2;
        }
        catch (PersonalBuildException e) {
            this.console.error(e.getMessage(), e);
            return 1;
        }
        return 0;
    }

    public int execute(BootContext context) throws ParseException {
        return this.execute(context.getCommandArgv());
    }

    public String getHelp() {
        return "request a personal build";
    }

    public String getDetailedHelp() {
        return "Sends a personal build request to a pulse server.  This involves updating\nthe current working copy, analysing any outstanding changes, forming a patch\nfile and sending the patch to the pulse server to execute a build.\n\nConfiguration is defined via properties files or command line arguments.  The\nconfiguration specifies connection details for the pulse server, along with\ninformation about the project and build specification you wish to execute.\nThe SCM configuration of the project must match the working copy.";
    }

    public List<String> getUsages() {
        return Arrays.asList("", "<file> ...", ":<changelist>");
    }

    public List<String> getAliases() {
        return Arrays.asList("pe", "per", "pers");
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-r [--project] project", "set project to build");
        options.put("-b [--specification] spec", "set build specification to build");
        options.put("-s [--server] url", "set pulse server url");
        options.put("-u [--user] name", "set pulse user name");
        options.put("-p [--password] password", "set pulse password");
        options.put("-f [--file] filename", "set patch file name");
        options.put("-d [--define] name=value", "set named property to given value");
        options.put("-q [--quiet]", "suppress unnecessary output");
        options.put("-v [--verbose]", "show verbose output");
        options.put("-n [--no-request]", "create patch but do not request build");
        options.put("-t [--status]", "show status only, do not update or build");
        return options;
    }

    public boolean isDefault() {
        return false;
    }

    public static void main(String[] argv) {
        PersonalBuildCommand command = new PersonalBuildCommand();
        try {
            System.exit(command.execute(argv));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

