/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.PropertiesConfig;
import com.zutubi.pulse.personal.ConsoleUI;
import com.zutubi.pulse.personal.PersonalBuildConfig;
import com.zutubi.pulse.personal.PersonalBuildException;
import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.xmlrpc.PulseXmlRpcClient;
import com.zutubi.pulse.xmlrpc.PulseXmlRpcException;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigCommand
implements Command {
    private boolean projectOnly = false;

    public int execute(BootContext bootContext) throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"project");
        options.addOption(OptionBuilder.create((char)'p'));
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(options, bootContext.getCommandArgv());
        if (commandLine.hasOption('p')) {
            this.projectOnly = true;
        }
        ConsoleUI ui = new ConsoleUI();
        PersonalBuildConfig config = new PersonalBuildConfig(new File(System.getProperty("user.dir")), (Config)new PropertiesConfig());
        if (!this.projectOnly) {
            this.setupPulseConfig(ui, config);
        }
        this.setupLocalConfig(ui, config);
        return 0;
    }

    public void setupPulseConfig(PersonalBuildUI ui, PersonalBuildConfig config) throws PersonalBuildException {
        String pulseURL = this.getPulseURL(ui);
        String pulseUser = this.getPulseUser(ui);
        ui.status("Storing Pulse server details in '" + config.getUserConfigFile().getAbsolutePath() + "'.");
        config.setProperty("pulse.url", pulseURL);
        config.setProperty("pulse.user", pulseUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPulseURL(PersonalBuildUI ui) {
        while (true) {
            PulseXmlRpcClient rpc;
            String pulseURL = ui.inputPrompt("Pulse URL [e.g. http://pulse:8080]");
            try {
                rpc = new PulseXmlRpcClient(pulseURL);
            }
            catch (MalformedURLException e) {
                ui.error("Invalid URL: " + e.getMessage(), (Throwable)e);
                continue;
            }
            try {
                rpc.getVersion();
                return pulseURL;
            }
            catch (PulseXmlRpcException e) {
                ui.error("Unable to contact pulse server: " + (Object)((Object)e), (Throwable)e);
                PersonalBuildUI.Response response = ui.ynPrompt("Continue with this URL anyway?", PersonalBuildUI.Response.NO);
                if (response.isAffirmative()) return pulseURL;
                continue;
            }
            break;
        }
    }

    private String getPulseUser(PersonalBuildUI ui) {
        String systemUser = System.getProperty("user.name");
        String pulseUser = systemUser == null ? ui.inputPrompt("Pulse user") : ui.inputPrompt("Pulse user", systemUser);
        return pulseUser;
    }

    public void setupLocalConfig(PersonalBuildUI ui, PersonalBuildConfig config) throws PersonalBuildException {
        String pulseProject = ui.inputPrompt("Pulse project");
        String spec = ui.inputPrompt("Build specification");
        ui.status("Storing project details in '" + config.getLocalConfigFile().getAbsolutePath() + "'.");
        config.setProperty("project", pulseProject, true);
        config.setProperty("specification", spec, true);
    }

    public String getHelp() {
        return "configure pulse server and project";
    }

    public String getDetailedHelp() {
        return "Configures the Pulse server and project details used for personal builds.\nYou will be prompted to enter the required details, and they will be stored\nin $HOME/.pulse.properties (server details) and ./.pulse.properties (project\ndetails).  You should run this command from the base directory of a working\ncopy for your project.  You can set up additional working copies for other\nprojects using the -p flag, which indicates that you do not wish to\nreconfigure the Pulse server details.";
    }

    public List<String> getUsages() {
        return Arrays.asList("");
    }

    public List<String> getAliases() {
        return Arrays.asList("conf", "configure");
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-p [--project]", "only configure project settings");
        return options;
    }

    public boolean isDefault() {
        return false;
    }
}

