/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.local;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.local.LocalBuild;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBuildCommand
implements Command {
    public int execute(BootContext context) {
        LocalBuild.main(context.getCommandArgv());
        return 0;
    }

    public String getHelp() {
        return "execute a local build";
    }

    public String getDetailedHelp() {
        return "Executes a local build in the current working directory.  A local build reads\na local pulse file (pulse.xml by default) and executes a specified recipe in\nyour development source tree.  This is useful for reproducing pulse builds\nexactly and for debugging pulse files when making changes.";
    }

    public List<String> getUsages() {
        return Arrays.asList("");
    }

    public List<String> getAliases() {
        return Arrays.asList("lo");
    }

    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("-r [--recipe] recipe", "set recipe to execute [default: the default recipe]");
        options.put("-p [--pulse-file] file", "use specified pulse file [default: pulse.xml]");
        options.put("-o [--output-dir] dir", "write output to directory [default: pulse.out]");
        options.put("-e [--resources-file] file", "use specified resources file [default: <none>]");
        return options;
    }

    public boolean isDefault() {
        return false;
    }
}

