/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String name) {
        StringBuffer b = new StringBuffer(name);
        try {
            UriParser.fixSeparators((StringBuffer)b);
            this.extractRootPrefix(name, b);
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuffer var2) throws FileSystemException;

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme((String)filename, (StringBuffer)name);
        if (scheme == null) {
            scheme = "file";
        }
        UriParser.canonicalizePath((StringBuffer)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuffer)name);
        String rootFile = this.extractRootPrefix(filename, name);
        FileType fileType = UriParser.normalisePath((StringBuffer)name);
        String path = name.toString();
        return this.createFileName(scheme, rootFile, path, fileType);
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

