/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xwork.results;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.io.WireFeedOutput;
import com.zutubi.pulse.util.Constants;
import com.zutubi.pulse.xwork.results.JITFeed;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JITFeedResult
extends WebWorkResultSupport {
    private String feedName = "feed";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String ETAG = "ETag";

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    protected void doExecute(String format, ActionInvocation actionInvocation) throws Exception {
        Date ifModifiedSince;
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        OgnlValueStack stack = actionInvocation.getStack();
        JITFeed feed = (JITFeed)stack.findValue(this.feedName);
        if (feed == null) {
            response.sendError(410);
            return;
        }
        response.setContentType("application/rss+xml; charset=UTF-8");
        response.setHeader("Content-Disposition", "filename=rss.xml");
        try {
            ifModifiedSince = new Date(request.getDateHeader(IF_MODIFIED_SINCE));
        }
        catch (Throwable t) {
            ifModifiedSince = Constants.DAY_0;
        }
        Date lastModified = ifModifiedSince;
        if (feed.hasEntries()) {
            lastModified = feed.getPublishedDate();
            Date updatedDate = feed.getUpdatedDate();
            if (updatedDate != null && lastModified.compareTo(updatedDate) < 0) {
                lastModified = updatedDate;
            }
        }
        String etag = Long.toString(lastModified.getTime());
        response.setHeader(ETAG, etag);
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastModified);
        cal.set(14, 0);
        lastModified = cal.getTime();
        response.setDateHeader(LAST_MODIFIED, lastModified.getTime());
        if ((TextUtils.stringSet((String)request.getHeader(IF_NONE_MATCH)) || TextUtils.stringSet((String)request.getHeader(IF_MODIFIED_SINCE))) && etag.equals(request.getHeader(IF_NONE_MATCH)) && lastModified.getTime() == ifModifiedSince.getTime()) {
            response.sendError(304);
            return;
        }
        WireFeed outFeed = feed.createWireFeed(format);
        outFeed.setEncoding(response.getCharacterEncoding());
        new WireFeedOutput().output(outFeed, (Writer)response.getWriter());
        response.flushBuffer();
    }
}

