/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateSessionInterceptor
implements Interceptor {
    private SessionFactory sessionFactory;

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        String result = null;
        this.before(invocation);
        try {
            result = invocation.invoke();
        }
        finally {
            this.after(invocation, result);
        }
        return result;
    }

    protected void before(ActionInvocation invocation) throws Exception {
        if (this.sessionFactory != null) {
            if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
                String reentryKey = this.getRentryKey();
                HttpServletRequest request = ServletActionContext.getRequest();
                Integer count = (Integer)request.getAttribute(reentryKey);
                int newCount = count != null ? count + 1 : 1;
                request.setAttribute(reentryKey, (Object)newCount);
            } else {
                Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
            }
        }
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
        if (this.sessionFactory != null) {
            String reentryKey = this.getRentryKey();
            HttpServletRequest request = ServletActionContext.getRequest();
            Integer count = (Integer)request.getAttribute(reentryKey);
            if (count != null) {
                if (count > 1) {
                    request.setAttribute(reentryKey, (Object)(count - 1));
                } else {
                    request.removeAttribute(reentryKey);
                }
            } else {
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                SessionFactoryUtils.releaseSession((Session)sessionHolder.getSession(), (SessionFactory)this.sessionFactory);
            }
        }
    }

    private String getRentryKey() {
        return this.sessionFactory.toString() + ".rentryCount";
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

