/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xwork.dispatcher;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.xwork.dispatcher.JsonDefinitionLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.json.JSONWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResult
extends WebWorkResultSupport {
    private static final Logger LOG = Logger.getLogger(JsonResult.class);
    private JsonDefinitionLoader definitionLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation ai) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        OgnlValueStack stack = ai.getStack();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
        JSONWriter jw = new JSONWriter((Writer)writer);
        if (!finalLocation.startsWith("/")) {
            finalLocation = ai.getProxy().getNamespace() + "/" + finalLocation;
        }
        Document doc = null;
        InputStream input = null;
        try {
            input = this.getDefinitionLoader().load(finalLocation);
            doc = this.parseInputStream(input);
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        Element root = doc.getDocumentElement();
        this.handleObject(root, jw, stack);
        response.setContentType("application/json");
        ((Writer)writer).flush();
    }

    private Document parseInputStream(InputStream input) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) {
            }

            public void error(SAXParseException exception) throws SAXException {
                LOG.error(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")");
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                LOG.error(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")");
                throw exception;
            }
        });
        return db.parse(input);
    }

    private void handleObject(Element e, JSONWriter jw, Object data) throws JSONException {
        List<Element> children = this.getChildElements(e);
        jw.object();
        for (Element elem : children) {
            this.handlePair(elem, jw, data);
        }
        jw.endObject();
    }

    private void handleArray(Element e, JSONWriter jw, Object data) throws JSONException {
        Object[] array;
        String ref = e.getAttribute("ref");
        Object newData = data;
        if (TextUtils.stringSet((String)ref)) {
            newData = this.evaluateReference(ref, data);
        }
        if (newData == null) {
            array = new Object[]{};
        } else if (newData instanceof Collection) {
            Collection c = (Collection)newData;
            array = c.toArray(new Object[c.size()]);
        } else {
            array = newData.getClass().isArray() ? (Object[])newData : new Object[]{newData};
        }
        jw.array();
        for (Object o : array) {
            this.handleValue(e, jw, o);
        }
        jw.endArray();
    }

    private void handleMap(Element e, JSONWriter jw, Object data) throws JSONException {
        String ref = e.getAttribute("ref");
        Object newData = this.evaluateReference(ref, data);
        if (!(newData instanceof Map)) {
            return;
        }
        Map map = (Map)newData;
        jw.object();
        for (Object o : map.keySet()) {
            jw.key(o.toString());
            this.handleValue(e, jw, map.get(o));
        }
        jw.endObject();
    }

    private void handlePair(Element e, JSONWriter jw, Object data) throws JSONException {
        String key = e.getAttribute("key");
        jw.key(key);
        this.handleValue(e, jw, data);
    }

    private void handleValue(Element e, JSONWriter jw, Object data) throws JSONException {
        List<Element> children = this.getChildElements(e);
        if (children.size() == 0) {
            String ref = e.getTextContent();
            if (TextUtils.stringSet((String)ref)) {
                Object o = this.evaluateReference(ref, data);
                jw.value(o != null ? o : "");
            } else {
                jw.value(data);
            }
        } else {
            for (Element child : children) {
                if (child.getLocalName().equals("object")) {
                    this.handleObject(child, jw, data);
                    continue;
                }
                if (child.getLocalName().equals("array")) {
                    this.handleArray(child, jw, data);
                    continue;
                }
                if (child.getLocalName().equals("map")) {
                    this.handleMap(child, jw, data);
                    continue;
                }
                throw new JSONException("Unexpected element: " + child.getLocalName() + ". Expected 'object' or 'array'");
            }
        }
    }

    private List<Element> getChildElements(Node n) {
        NodeList children = n.getChildNodes();
        LinkedList<Element> elements = new LinkedList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    private Object evaluateReference(String ref, Object data) {
        if (data instanceof OgnlValueStack) {
            OgnlValueStack stack = (OgnlValueStack)data;
            return stack.findValue(ref);
        }
        OgnlValueStack stack = new OgnlValueStack();
        stack.push(data);
        return stack.findValue(ref);
    }

    public void setDefinitionLoader(JsonDefinitionLoader definitionLoader) {
        this.definitionLoader = definitionLoader;
    }

    public JsonDefinitionLoader getDefinitionLoader() {
        if (this.definitionLoader == null) {
            this.definitionLoader = this.getDefaultDefinitionLoader();
        }
        return this.definitionLoader;
    }

    private JsonDefinitionLoader getDefaultDefinitionLoader() {
        final MasterConfigurationManager config = (MasterConfigurationManager)ComponentContext.getBean((String)"configurationManager");
        return new JsonDefinitionLoader(){

            public InputStream load(String location) throws FileNotFoundException {
                File contentRoot = config.getSystemPaths().getContentRoot();
                File definition = new File(contentRoot, location);
                return new FileInputStream(definition);
            }
        };
    }
}

