/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.wizard.auto;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.ui.FormSupport;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.validation.MessagesTextProvider;
import com.zutubi.pulse.web.ActionSupport;
import com.zutubi.pulse.wizard.Wizard;
import com.zutubi.validation.DelegatingValidationContext;
import com.zutubi.validation.ValidationAware;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationException;
import com.zutubi.validation.ValidationManager;
import com.zutubi.validation.XWorkValidationAdapter;
import com.zutubi.validation.i18n.TextProvider;
import freemarker.template.Configuration;
import java.util.Map;

public class WizardAction
extends ActionSupport {
    private static final Logger LOG = Logger.getLogger(WizardAction.class);
    private String wizard;
    private boolean wizardRequiresLazyInitialisation = false;
    private String cancel;
    private String next;
    private String previous;
    private String finish;
    private String submit;
    private ObjectFactory objectFactory;
    private ValidationManager validationManager;
    private Configuration configuration;
    private DescriptorFactory descriptorFactory;

    public void setWizard(String wizard) {
        this.wizard = wizard;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setPrevious(String previous) {
        this.previous = previous;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public boolean isInitialised() {
        this.getWizardInstance();
        return !this.wizardRequiresLazyInitialisation;
    }

    public boolean isCancelSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("cancel");
        }
        return TextUtils.stringSet((String)this.cancel);
    }

    public boolean isPreviousSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("previous");
        }
        return TextUtils.stringSet((String)this.previous);
    }

    public boolean isNextSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("next");
        }
        return TextUtils.stringSet((String)this.next);
    }

    public boolean isFinishSelected() {
        if (TextUtils.stringSet((String)this.submit)) {
            return this.submit.equals("finish");
        }
        return TextUtils.stringSet((String)this.finish);
    }

    protected void initWizardIfRequired() {
        Wizard wizard = this.getWizardInstance();
        if (this.wizardRequiresLazyInitialisation) {
            wizard.initialise();
            this.wizardRequiresLazyInitialisation = false;
        }
    }

    private boolean validateState() {
        try {
            Object state = this.getState();
            FormSupport support = this.createFormSupport(state);
            ValidationContext validationContext = this.createValidationContext(state, this);
            support.populateObject(state);
            this.validationManager.validate(state, validationContext);
            return !this.hasErrors();
        }
        catch (ValidationException e) {
            this.addActionError(e.getMessage());
            return false;
        }
    }

    private boolean validateWizard() {
        try {
            Wizard wizard = this.getWizardInstance();
            ValidationContext validationContext = this.createValidationContext(wizard, this);
            this.validationManager.validate((Object)wizard, validationContext);
            return !this.hasErrors();
        }
        catch (ValidationException e) {
            this.addActionError(e.getMessage());
            return false;
        }
    }

    public String execute() {
        if (!(!this.isNextSelected() && !this.isFinishSelected() || this.validateState() && this.validateWizard())) {
            return "step";
        }
        try {
            this.initWizardIfRequired();
            if (this.isCancelSelected()) {
                return this.doCancel();
            }
            if (this.isNextSelected()) {
                return this.doNext();
            }
            if (this.isPreviousSelected()) {
                return this.doPrevious();
            }
            if (this.isFinishSelected()) {
                return this.doFinish();
            }
            return "step";
        }
        catch (Exception e) {
            this.handleException(e);
            return "error";
        }
    }

    private String doFinish() {
        try {
            this.initWizardIfRequired();
            this.getWizardInstance().doFinish();
            this.removeWizard();
            return "success";
        }
        catch (Exception e) {
            this.handleException(e);
            return "error";
        }
    }

    private String doPrevious() {
        try {
            this.initWizardIfRequired();
            this.getWizardInstance().doPrevious();
            return "step";
        }
        catch (Exception e) {
            this.handleException(e);
            return "error";
        }
    }

    private String doNext() {
        try {
            this.initWizardIfRequired();
            this.getWizardInstance().doNext();
            return "step";
        }
        catch (Exception e) {
            this.handleException(e);
            return "error";
        }
    }

    private String doCancel() {
        try {
            this.initWizardIfRequired();
            this.getWizardInstance().doCancel();
            this.removeWizard();
            return "cancel";
        }
        catch (Exception e) {
            this.handleException(e);
            return "error";
        }
    }

    public Object getState() {
        return this.getWizardInstance().getCurrentState();
    }

    private void removeWizard() {
        ActionContext.getContext().getSession().remove(this.wizard);
    }

    private void handleException(Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        this.addActionError("Unexpected exception: " + e.getClass().getName() + ", " + e.getMessage());
        this.removeWizard();
    }

    public Wizard getWizardInstance() {
        try {
            Map session = ActionContext.getContext().getSession();
            if (!session.containsKey(this.wizard)) {
                Wizard wizardInstance = (Wizard)this.objectFactory.buildBean(this.wizard);
                this.wizardRequiresLazyInitialisation = true;
                session.put(this.wizard, wizardInstance);
            }
            return (Wizard)session.get(this.wizard);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ValidationContext createValidationContext(Object subject, WizardAction wizardAction) {
        MessagesTextProvider textProvider = new MessagesTextProvider(subject);
        return new DelegatingValidationContext((ValidationAware)new XWorkValidationAdapter((com.opensymphony.xwork.ValidationAware)wizardAction), (TextProvider)textProvider);
    }

    private FormSupport createFormSupport(Object subject) {
        FormSupport support = new FormSupport();
        support.setConfiguration(this.configuration);
        support.setDescriptorFactory(this.descriptorFactory);
        support.setTextProvider(new com.zutubi.pulse.form.MessagesTextProvider(subject));
        return support;
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    public void setFreemarkerConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }
}

